/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// htmlgeneratorfactory.cc

#include "htmlgeneratorfactory.h"

#include "html_chartranslator.h"
#include "htmldecorator.h"
#include "htmltags.h"
#include "htmldocgenerator.h"
#include "colormap.h"
#include "colors.h"

HtmlGeneratorFactory::HtmlGeneratorFactory(bool line_number, const string &t,
                                           bool line_ref,
    const string &i, const string &h, const string &f, const string &c) :
  GeneratorFactory (line_number, t, line_ref), 
  input_file_name (i), doc_header (h),
  doc_footer (f), css_url (c)
{
}

TextGenerator *
HtmlGeneratorFactory::createBoldDecorator(TextGenerator *gen)
{
  return new TagDecorator( gen, char_translator, BOLD_TAG ) ;
}

TextGenerator *
HtmlGeneratorFactory::createItalicDecorator(TextGenerator *gen)
{
  return new TagDecorator( gen, char_translator, ITALIC_TAG ) ;
}

TextGenerator *
HtmlGeneratorFactory::createUnderlineDecorator(TextGenerator *gen)
{
  return new TagDecorator( gen, char_translator, UNDERLINE_TAG ) ;
}

TextGenerator *
HtmlGeneratorFactory::createColorDecorator(TextGenerator *gen, const string &color)
{
  return new ColorDecorator( gen, char_translator, color ) ;
}

CharTranslator *
HtmlGeneratorFactory::createCharTranslator()
{
  return new HtmlCharTranslator ();
}

DocGenerator *
HtmlGeneratorFactory::createDocGenerator()
{
  return new HtmlDocGenerator (title, input_file_name, doc_header, doc_footer,
                               css_url);
}

ColorMap *
HtmlGeneratorFactory::createColorMap()
{
  ColorMap *cm = new ColorMap;

  (*cm)[ GREEN ] ="#33CC00";
  (*cm)[ RED ] ="#FF0000";
  (*cm)[ DARKRED ] ="#990000";
  (*cm)[ BLUE ] ="#0000FF";
  (*cm)[ BROWN ] ="#9A1900";
  (*cm)[ PINK ] ="#CC33CC";
  (*cm)[ YELLOW ] ="#FFCC00";
  (*cm)[ CYAN ] ="#66FFFF";
  (*cm)[ PURPLE ] ="#993399";
  (*cm)[ ORANGE ] ="#FF6600";
  (*cm)[ BRIGHTORANGE ] ="#FF9900";
  (*cm)[ BRIGHTGREEN ] ="#33FF33";
  (*cm)[ DARKGREEN ] ="#009900";
  (*cm)[ BLACK ] ="#000000";
  (*cm)[ TEAL ] ="#008080";
  (*cm)[ GRAY ] ="#808080";
  (*cm)[ DARKBLUE ] ="#000080";

  cm->setDefault ("#000000");

  return cm;
}

