//
// C++ Interface: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef REGEXPSTATE_H
#define REGEXPSTATE_H

#include <boost/regex.hpp>
#include <boost/shared_ptr.hpp>
#include <deque>
#include "my_sstream.h"

struct RegExpState;

typedef boost::shared_ptr<RegExpState> RegExpStatePtr;

struct RegExpFormatter
{
  const std::string elem; // the element represented
  bool exit_state;
  bool exit_all;

  RegExpFormatter(const std::string &el, RegExpStatePtr r = RegExpStatePtr(), bool exit = false, bool all = false);

  void setNextState(RegExpStatePtr r);
  RegExpStatePtr getNextState() const;

  private:
    RegExpStatePtr next_state;
};

typedef boost::shared_ptr<RegExpFormatter> RegExpFormatterPtr;
typedef std::deque<RegExpFormatterPtr> format_vector;

/**
class representing a state for the regular expression engine

@author Lorenzo Bettini
 */
struct RegExpState
{
  boost::regex reg_exp;
  format_vector formatters;
  int current_formatter;
  std::ostringstream buffer;

  RegExpState() : formatters(1), current_formatter(0) {}

  const std::string &get_elem(int index = -1);
  void add_exp(const std::string &s, RegExpFormatterPtr f);
  void freeze() throw(boost::bad_expression);
  void add_normal_formatter(RegExpFormatterPtr f);
  RegExpFormatterPtr getLastFormatter() const { return formatters[formatters.size()-1];}
};

#endif
