/*
 * This file is part of LibEuFin.
 * Copyright (C) 2025 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

import org.junit.Test
import tech.libeufin.common.*
import kotlin.test.*

class BaseUrlTest {
    @Test
    fun test() {
        for (valid in listOf(
            "https://www.example.com/",
            "http://localhost:8080/",
            "https://api.example.com/v1/",
            "https://example.com:3000/path/",
        )) {
            val parsed = BaseURL.parse(valid)
            assertEquals(parsed.toString(), valid)
        }

        for (invalid in listOf(
            "https://example.com?param=value",
            "https://example.com#section",
            "https://not.a/base/url",
            "file://not.http.com/",
            "not-a-url",
            "no.transport.com/",
            "://example.com",
            "https://",
            "",
            "   ",
        )) {
            assertFails { BaseURL.parse(invalid) }
        }
    }
}