/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { j2s } from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { makeNoFeeCoinConfig } from "../harness/denomStructures.js";
import { GlobalTestState } from "../harness/harness.js";
import {
  createSimpleTestkudosEnvironmentV3,
  makeTestPaymentV2,
  withdrawViaBankV3,
} from "../harness/helpers.js";

/**
 * Related bugs:
 * https://bugs.taler.net/n/8323
 */
export async function runWalletBalanceZeroTest(t: GlobalTestState) {
  // Set up test environment

  const coinConfig = makeNoFeeCoinConfig("TESTKUDOS");
  console.log(`coin config ${j2s(coinConfig)}`);
  const { merchant, walletClient, exchange, bankClient } =
    await createSimpleTestkudosEnvironmentV3(t, coinConfig);

  const wres = await withdrawViaBankV3(t, {
    amount: "TESTKUDOS:10",
    bankClient,
    exchange,
    walletClient,
  });
  await wres.withdrawalFinishedCond;

  await makeTestPaymentV2(t, {
    walletClient,
    merchant,
    order: {
      summary: "Hello, World!",
      amount: "TESTKUDOS:10",
    },
  });

  const bal = await walletClient.call(WalletApiOperation.GetBalances, {});
  console.log(`${j2s(bal)}`);
  t.assertAmountEquals(bal.balances[0].available, "TESTKUDOS:0");
}

runWalletBalanceZeroTest.suites = ["wallet"];
