/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { AmountField } from "../../components/AmountField.js";
import { Button } from "../../mui/Button.js";
import { TextField } from "../../mui/TextField.js";
import { State } from "./index.js";
import { AgeSign } from "../../components/styled/index.js";

export function ReadyView({
  amount,
  minAge,
  summary,
  onCreate,
}: State.FillTemplate): VNode {
  const { i18n } = useTranslationContext();

  return (
    <Fragment>
      <section style={{ textAlign: "left" }}>
        {!amount ? undefined : (
          <p>
            <AmountField label={i18n.str`Amount`} 
            handler={amount} 
            />
          </p>
        )}
        {!summary ? undefined : (
          <p>
            <TextField
              label="Summary"
              variant="filled"
              required
              fullWidth
              disabled={summary.onInput === undefined}
              error={summary.error}
              value={summary.value}
              onChange={summary.onInput}
            />
          </p>
        )}
      </section>
      {minAge ? (
        <section>
          <AgeSign size={25}>{minAge}+</AgeSign>
          <i18n.Translate>This purchase is age restricted.</i18n.Translate>
        </section>
      ) : undefined}
      <section>
        <Button onClick={onCreate.onClick} variant="contained" color="success">
          <i18n.Translate>Review order</i18n.Translate>
        </Button>
      </section>
    </Fragment>
  );
}
