/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { Amounts } from "@gnu-taler/taler-util";
import * as tests from "@gnu-taler/web-util/testing";
import { nullFunction } from "../../mui/handlers.js";
import { ReadyView } from "./views.js";

export default {
  title: "deposit",
};

export const WithNoAccountForIBAN = tests.createExample(ReadyView, {
  status: "ready",
  account: {
    list: {},
    value: "",
    onChange: nullFunction,
  },
  currentAccount: {
    isKnown: true,
    targetType: "iban",
    iban: "ABCD1234",
    params: {},
    targetPath: "/ABCD1234",
  },
  currency: "USD",
  amount: {
    onInput: nullFunction,
    value: Amounts.parseOrThrow("USD:10"),
  },
  onAddAccount: {},
  cancelHandler: {},
  depositHandler: {
    onClick: nullFunction,
  },
  totalFee: Amounts.zeroOfCurrency("USD"),
  totalToDeposit: {
    onInput:nullFunction,
    value: Amounts.parseOrThrow("USD:10"),
  },
  // onCalculateFee: alwaysReturnFeeToOne,
});

export const WithIBANAccountTypeSelected = tests.createExample(ReadyView, {
  status: "ready",
  account: {
    list: { asdlkajsdlk: "asdlkajsdlk", qwerqwer: "qwerqwer" },
    value: "asdlkajsdlk",
    onChange: nullFunction,
  },
  currentAccount: {
    isKnown: true,
    targetType: "iban",
    iban: "ABCD1234",
    params: {},
    targetPath: "/ABCD1234",
  },
  currency: "USD",
  amount: {
    onInput: nullFunction,
    value: Amounts.parseOrThrow("USD:10"),
  },
  onAddAccount: {},
  cancelHandler: {},
  depositHandler: {
    onClick: nullFunction,
  },
  totalFee: Amounts.zeroOfCurrency("USD"),
  totalToDeposit: {
    onInput:nullFunction,
    value: Amounts.parseOrThrow("USD:10"),
  },
  // onCalculateFee: alwaysReturnFeeToOne,
});

export const NewBitcoinAccountTypeSelected = tests.createExample(ReadyView, {
  status: "ready",
  account: {
    list: {},
    value: "asdlkajsdlk",
    onChange: nullFunction,
  },
  currentAccount: {
    isKnown: true,
    targetType: "iban",
    iban: "ABCD1234",
    params: {},
    targetPath: "/ABCD1234",
  },
  onAddAccount: {},
  currency: "USD",
  amount: {
    onInput: nullFunction,
    value: Amounts.parseOrThrow("USD:10"),
  },
  cancelHandler: {},
  depositHandler: {
    onClick: nullFunction,
  },
  totalFee: Amounts.zeroOfCurrency("USD"),
  totalToDeposit: {
    onInput:nullFunction,
    value: Amounts.parseOrThrow("USD:10"),
  },
  // onCalculateFee: alwaysReturnFeeToOne,
});
