#include <sys/types.h>
#include <sys/syscall.h>

#include <stdio.h>

struct syscall {
  char *name;
  int   vec;
} syscalls[] = {
#define SYSTEM_CALL(func,vec) #func, vec,
#include <sys/syscall.def>
#undef SYSTEM_CALL
};
int nsyscall = sizeof(syscalls) / sizeof (syscalls[0]);

main()
{
  FILE *fp1, *fp2;
  struct syscall *sc;
  int i, v;

  for (i = 0, sc = syscalls; i < nsyscall; i++, sc++)
    {
      char name1[strlen (sc->name) + 3];
    
      v = -(sc->vec + 4)*6;
      
      sprintf (name1, "%s.s", sc->name);

      fp1 = fopen (name1, "w");
      
      if (!fp1)
        {
          perror (sc->name);
          exit (20);
        }

      fprintf (fp1, ".globl _%s; _%s: movel a4@(_ixemulbase:W), a0; "
			"addw #%d,a0; jsr a0@; "
			"tstl a4; bne Ldo_rts; "
			"pea Lsuender; jmp _eeak_a_bug; "
			"Ldo_rts: rts; Lsuender: .asciz \"%s\";.even\n",
			 sc->name, sc->name, v, sc->name);
      fclose (fp1);
    }
}

