/*	NGT -- Network Graphics Terminal for Apollo Emacs using GPR	     */
/*									     */
/*	Copyright (C) 1987 by Leonard N. Zubkoff, All Rights Reserved	     */
/*									     */
/*	This software is provided free and without any warranty.	     */
/*	Permission to copy for any purpose is hereby granted so		     */
/*	long as this copyright notice remains intact.			     */
/*									     */
/*	Revision:	 4-Feb-91 01:42:22				     */


#define C_InitializeTerminal		0x00
#define C_ResetTerminal			0x01
#define C_IconizeTerminal		0x02
#define C_RingBell			0x03
#define C_DefineWindow			0x04
#define C_ClearScreen			0x05
#define C_ClearToEndOfLine		0x06
#define C_ClearToEndOfWindow		0x07
#define C_HomeCursor			0x08
#define C_CursorDownAndReturn		0x09
#define C_CursorDownAndWriteColumn	0x0A
#define C_WriteCursorPosition		0x0B
#define C_DeleteCharacters		0x0C
#define C_OpenSpaces			0x0D
#define C_InsertSpaces			0x0E
#define C_OverwriteSpaces		0x0F
#define C_OverwriteCharacters		0x10
#define C_DeleteLines			0x11
#define C_InsertLines			0x12
#define C_HighlightModeOn		0x13
#define C_HighlightModeOff		0x14
#define C_EnableApolloFunctionKey	0x15
#define C_DisableApolloFunctionKey	0x16
#define C_EnableApolloMouseButton	0x17
#define C_DisableApolloMouseButton	0x18
#define C_SetApolloMetaKey		0x19
#define C_WritePasteBuffer		0x1A
#define C_ReadPasteBuffer		0x1B
#define C_ExecuteDMCommand		0x1C

#define L_DefineAndDisplayDynamicToken	0x90
#define U_DefineAndDisplayDynamicToken	0xBF
#define L_DisplayDynamicToken		0xC2
#define U_DisplayDynamicToken		0xC7
#define L_DisplayStaticToken		0xC8
#define U_DisplayStaticToken		0xDF
#define L_DisplayQuickToken		0xE0
#define U_DisplayQuickToken		0xFF


#define N_Keystroke			0x00
#define N_FunctionKey			0x01
#define N_Buttons			0x02
#define N_Refresh			0x03
#define N_SetObscured			0x04
#define N_PasteBuffer			0x05


#define DefineCommandArgumentCounts					    \
    static char CommandArgumentCounts[256] =				    \
	{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 2, 1, 1, 1, 1,		    \
	  2, 2, 2, 0, 0, 1, 1, 1, 1, 1, 3, 0, 9, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,		    \
	  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,		    \
	  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,		    \
	  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,		    \
	  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		    \
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }


#define Z_InitializeTerminal()						    \
    begin								    \
	OutputByte(C_InitializeTerminal);				    \
    end


#define Z_ResetTerminal()						    \
    begin								    \
	OutputByte(C_ResetTerminal);					    \
    end


#define Z_IconizeTerminal()						    \
    begin								    \
	OutputByte(C_IconizeTerminal);					    \
    end


#define Z_RingBell()							    \
    begin								    \
	OutputByte(C_RingBell);						    \
    end


#define Z_DefineWindow(WindowLines)					    \
    begin								    \
	OutputByte(C_DefineWindow);					    \
	OutputByte((WindowLines));					    \
    end


#define Z_ClearScreen()							    \
    begin								    \
	OutputByte(C_ClearScreen);					    \
    end


#define Z_ClearToEndOfLine()						    \
    begin								    \
	OutputByte(C_ClearToEndOfLine);					    \
    end


#define Z_ClearToEndOfWindow()						    \
    begin								    \
	OutputByte(C_ClearToEndOfWindow);				    \
    end


#define Z_HomeCursor()							    \
    begin								    \
	OutputByte(C_HomeCursor);					    \
    end


#define Z_CursorDownAndReturn()						    \
    begin								    \
	OutputByte(C_CursorDownAndReturn);				    \
    end


#define Z_CursorDownAndWriteColumn(Column)				    \
    begin								    \
	OutputByte(C_CursorDownAndWriteColumn);				    \
	OutputByte((Column));						    \
    end


#define Z_WriteCursorPosition(Line,Column)				    \
    begin								    \
	OutputByte(C_WriteCursorPosition);				    \
	OutputByte((Line));						    \
	OutputByte((Column));						    \
    end


#define Z_DeleteCharacters(DeleteCount)					    \
    begin								    \
	OutputByte(C_DeleteCharacters);					    \
	OutputByte((DeleteCount));					    \
    end


#define Z_OpenSpaces(OpenCount)						    \
    begin								    \
	OutputByte(C_OpenSpaces);					    \
	OutputByte((OpenCount));					    \
    end


#define Z_InsertSpaces(InsertCount)					    \
    begin								    \
	OutputByte(C_InsertSpaces);					    \
	OutputByte((InsertCount));					    \
    end


#define Z_OverwriteSpaces(OverwriteCount)				    \
    begin								    \
	OutputByte(C_OverwriteSpaces);					    \
	OutputByte((OverwriteCount));					    \
    end


#define Z_OverwriteCharacters(OverwriteCount,OverwriteCharacter)	    \
    begin								    \
	OutputByte(C_OverwriteCharacters);				    \
	OutputByte((OverwriteCount));					    \
	OutputByte((OverwriteCharacter));				    \
    end


#define Z_DeleteLines(Line,DeleteCount)					    \
    begin								    \
	OutputByte(C_DeleteLines);					    \
	OutputByte((Line));						    \
	OutputByte((DeleteCount));					    \
    end


#define Z_InsertLines(Line,InsertCount)					    \
    begin								    \
	OutputByte(C_InsertLines);					    \
	OutputByte((Line));						    \
	OutputByte((InsertCount));					    \
    end


#define Z_HighlightModeOn()						    \
    begin								    \
	OutputByte(C_HighlightModeOn);					    \
    end


#define Z_HighlightModeOff()						    \
    begin								    \
	OutputByte(C_HighlightModeOff);					    \
    end


#define Z_EnableApolloFunctionKey(KeyCode)				    \
    begin								    \
	OutputByte(C_EnableApolloFunctionKey);				    \
	OutputByte((KeyCode));						    \
    end


#define Z_DisableApolloFunctionKey(KeyCode)				    \
    begin								    \
	OutputByte(C_DisableApolloFunctionKey);				    \
    end


#define Z_EnableApolloMouseButton(KeyCode)				    \
    begin								    \
	OutputByte(C_EnableApolloMouseButton);				    \
	OutputByte((KeyCode));						    \
    end


#define Z_DisableApolloMouseButton(KeyCode)				    \
    begin								    \
	OutputByte(C_DisableApolloMouseButton);				    \
	OutputByte((KeyCode));						    \
    end


#define Z_SetApolloMetaKey(KeyCode)					    \
    begin								    \
	OutputByte(C_SetApolloMetaKey);					    \
	OutputByte((KeyCode));						    \
    end


#define Z_ReadPasteBuffer()						    \
    begin								    \
	OutputByte(C_ReadPasteBuffer);					    \
    end


#define Z_WritePasteBuffer(Length)					    \
    begin								    \
	int ByteCount = (Length);					    \
	OutputByte(C_WritePasteBuffer);					    \
	OutputByte((ByteCount>>16));					    \
	OutputByte((ByteCount>>8));					    \
	OutputByte((ByteCount));					    \
    end


#define Z_ExecuteDMCommand(Length)					    \
    begin								    \
	OutputByte(C_ExecuteDMCommand);					    \
	OutputByte((Length));						    \
    end


#define Z_DefineAndDisplayDynamicToken(TokenType,ByteCount)		    \
    begin								    \
	OutputByte(0x80 | ((TokenType)<<3) | ((ByteCount)-1));		    \
    end


#define Z_DisplayDynamicToken(TokenNumber,TokenType)			    \
    begin								    \
	OutputByte(0xC0 | (TokenType));					    \
	OutputByte((TokenNumber));					    \
    end


#define Z_DisplayStaticToken(TokenNumber,TokenType)			    \
    begin								    \
	OutputByte(0xC0 | ((TokenType)<<2) | ((TokenNumber)>>8));	    \
	OutputByte((TokenNumber) & 0xFF);				    \
    end


#define Z_DisplayQuickToken(TokenNumber)				    \
    begin								    \
	OutputByte(0xE0 | ((TokenNumber)&0x1F));			    \
    end
