/*	UNEXAPOLLO -- COFF File UNEXEC for GNU Emacs on Apollo SR10.2	     */
/*									     */
/*	Copyright (C) 1988 by Leonard N. Zubkoff, All Rights Reserved	     */
/*									     */
/*	This software is provided free and without any warranty.	     */
/*	Permission to copy for any purpose is hereby granted so		     */
/*	long as this copyright notice remains intact.			     */
/*									     */
/*	Revision:	19-Jul-90 09:18:11				     */


#define begin	    {
#define end	    }
#define then
#define do
#define hidden	    static
#define visible
#define procedure   void


#include "config.h"
#include <fcntl.h>


#include <a.out.h>
#include <sys/file.h>
#include <apollo/base.h>
#include <apollo/ios.h>
#include <apollo/type_uids.h>
#include <apollo/dst.h>


#define DST_RECORD_HDR_SIZE	2


visible procedure unexec(char *TargetFileName,
			 char *SourceFileName)
    begin
	struct filehdr FileHeader;
	struct aouthdr DomainHeader;
	struct scnhdr *Section, *Sections, *SectionsLimit;
	struct scnhdr *DataSection, *RwdiSection, *BlocksSection;
	struct reloc RelocEntry;
	unsigned long DataSize, SourceFileOffsetPastRwdi;
	unsigned char Buffer[4096];
	long Delta, ByteCount, FirstChangedVaddr, i;
	ios_$id_t TargetFile, SourceFile;
	status_$t Status;
	/* Open the Source File. */
	if ((SourceFile = open(SourceFileName,O_RDONLY)) < 0) then
	    error("cannot open source file for input");
	/* Read the File Header. */
	if (read(SourceFile,&FileHeader,sizeof(FileHeader))
		!= sizeof(FileHeader)) then
	    error("cannot read file header");

	/* Read the Domain Header. */
	if (read(SourceFile,&DomainHeader,sizeof(DomainHeader))
		!= sizeof(DomainHeader)) then
	    error("cannot read domain header");
	/* Read the Section Headers. */
	Sections = (struct scnhdr *) malloc(FileHeader.f_nscns
					    *sizeof(struct scnhdr));
	if (Sections == (struct scnhdr *) 0) then
	    error("cannot allocate section header storage");
	SectionsLimit = Sections+FileHeader.f_nscns;
	if (read(SourceFile,Sections,FileHeader.f_nscns*sizeof(struct scnhdr))
		!= FileHeader.f_nscns*sizeof(struct scnhdr)) then
	    error("cannot read section headers");
	/* Compute the new Size of the Data Section. */
	DataSize = sbrk(0)-DomainHeader.data_start;
	/* Find and Deallocate the .rwdi Section Information. */
	for (RwdiSection=Sections;
	     RwdiSection != SectionsLimit; RwdiSection++) do
		if (strcmp(RwdiSection->s_name,".rwdi") == 0) then
		    begin
			/* If there are relocation entries, we
			   cannot "unrelocate" them. */
			if (RwdiSection->s_nreloc > 0)
			    error(".rwdi section needs relocation - \
				   cannot dump Emacs");
			Delta = DataSize-DomainHeader.dsize
					-RwdiSection->s_size;
			RwdiSection->s_paddr = 0;
			RwdiSection->s_vaddr = 0;
			RwdiSection->s_scnptr = 0;
			RwdiSection->s_size = 0;
			SourceFileOffsetPastRwdi = (RwdiSection+1)->s_scnptr;
			break;
		    end;
	/* Skip over the Text Section Headers. */
	for (Section=Sections;
	     (Section->s_flags & STYP_TEXT) != 0; Section++) do ;
	/* Increment the Relocation Pointers in Data Section Headers. */
	for (; Section != SectionsLimit; Section++) do
	    if ((Section->s_flags & STYP_DATA) != 0) then
		begin
		    DataSection = Section;
		    DataSection->s_relptr += Delta;
		end;
	/* Increment the Size of the Last Data Section. */
	DataSection->s_size += DataSize-DomainHeader.dsize;
	/* Update the File Header and Domain Header. */
	FileHeader.f_symptr += Delta;
	DomainHeader.dsize = DataSize;
	DomainHeader.bsize = 0;
	DomainHeader.o_sri += Delta;
	DomainHeader.o_inlib += Delta;

 	/* Skip over subsequent Bss Section Headers. */
 	for (Section=DataSection+1;
 	     (Section->s_flags & STYP_BSS) != 0; Section++) do ;
 	/* Update the remaining Section Headers. */
        BlocksSection = (struct scnhdr *) 0;
        FirstChangedVaddr = 0;
 	for (; Section != SectionsLimit; Section++) do
	    begin
		if (Section->s_paddr != 0) then
		    Section->s_paddr += Delta;
		if (Section->s_vaddr != 0) then
                    begin
                        if (FirstChangedVaddr == 0) then
                            FirstChangedVaddr = Section->s_vaddr;
		        Section->s_vaddr += Delta;
                    end;
		if (Section->s_scnptr != 0) then
		    Section->s_scnptr += Delta;
                if (strcmp (Section->s_name, ".blocks") == 0) then
                    BlocksSection = Section;
	    end;
	/* Open the Target File. */
	ios_$create(TargetFileName,strlen(TargetFileName),coff_$uid,
		    ios_$recreate_mode,ios_$write_opt,&TargetFile,&Status);
	if (Status.all != status_$ok) then
	    error("cannot open target file for output");
	/* Write the File Header. */
	if (write(TargetFile,&FileHeader,sizeof(FileHeader))
		!= sizeof(FileHeader)) then
	    error("cannot write file header");
	/* Write the Domain Header. */
	if (write(TargetFile,&DomainHeader,sizeof(DomainHeader))
		!= sizeof(DomainHeader)) then
	    error("cannot write domain header");
	/* Write the Section Headers. */
	if (write(TargetFile,Sections,FileHeader.f_nscns*sizeof(struct scnhdr))
		!= FileHeader.f_nscns*sizeof(struct scnhdr)) then
	    error("cannot write section headers");
	/* Copy the Allocated Sections. */
	for (Section=Sections; Section != DataSection; Section++) do
	    if (Section->s_scnptr != 0) then
		CopyData(TargetFile,SourceFile,Section->s_size);
	/* Write the Expanded Data Segment. */
	if (write(TargetFile,DataSection->s_vaddr,
		  DataSection->s_size) != DataSection->s_size) then
	    error("cannot write new data section");
	/* Skip over the Last Data Section and Copy until the .rwdi Section. */
	if (lseek(SourceFile,DataSection->s_scnptr
			     +DataSection->s_size,L_SET) == -1) then
	    error("cannot seek past data section");
	for (Section=DataSection+1; Section != RwdiSection; Section++) do
	    if (Section->s_scnptr != 0) then
		CopyData(TargetFile,SourceFile,Section->s_size);
	/* Skip over the .rwdi Section and Copy Remainder of Source File. */
	if (lseek(SourceFile,SourceFileOffsetPastRwdi,L_SET) == -1) then
	    error("cannot seek past .rwdi section");
	while ((ByteCount = read(SourceFile,Buffer,sizeof(Buffer))) > 0) do
	    if (write(TargetFile,Buffer,ByteCount) != ByteCount) then
		error("cannot write data");

	/* Unrelocate .data references to Global Symbols. */
	for (i=0; i<DataSection->s_nreloc; i++) do
	    begin
		if (lseek(SourceFile,DataSection->s_relptr
				     +i*sizeof(struct reloc)-Delta,
			  L_SET) == -1) then
		    error("cannot seek to relocation info");
		if (read(SourceFile,&RelocEntry,sizeof(RelocEntry))
			!= sizeof(RelocEntry)) then
		    error("cannot read reloc entry");
		if (lseek(SourceFile,RelocEntry.r_vaddr-DataSection->s_vaddr
				     +DataSection->s_scnptr,L_SET) == -1) then
		    error("cannot seek to data element");
		if (lseek(TargetFile,RelocEntry.r_vaddr-DataSection->s_vaddr
				     +DataSection->s_scnptr,L_SET) == -1) then
		    error("cannot seek to data element");
		if (read(SourceFile,Buffer,4) != 4) then
		    error("cannot read data element");
		if (write(TargetFile,Buffer,4) != 4) then
		    error("cannot write data element");
	    end;
	/* Correct virtual addresses in .blocks section. */
	if (BlocksSection != (struct scnhdr *) 0) then
	    begin
		dst_rec_t DstRecord;
		dst_rec_comp_unit_t *CompUnit;
		unsigned short NumberOfSections;
		unsigned long SectionBase;
		unsigned long SectionOffset = 0;
		/* Find section tables and update section base addresses. */
		while (SectionOffset < BlocksSection->s_size) do
		    begin
			if (lseek(TargetFile,
				  BlocksSection->s_scnptr+SectionOffset,
				  L_SET) == -1) then
			    error("cannot seek to comp unit record");
			/* Handle pad records before the comp unit record. */
			if (read(TargetFile,&DstRecord,DST_RECORD_HDR_SIZE)
				!= DST_RECORD_HDR_SIZE) then
			    error("cannot read dst record tag");
			if (DstRecord.rec_type == dst_typ_pad) then
			    SectionOffset += DST_RECORD_HDR_SIZE;
			else if (DstRecord.rec_type == dst_typ_comp_unit) then
			    begin
				CompUnit = &DstRecord.rec_data.comp_unit_;
				if (read(TargetFile,CompUnit,sizeof(*CompUnit))
					!= sizeof (*CompUnit)) then
				    error("cannot read comp unit record");
				if (lseek(TargetFile,BlocksSection->s_scnptr
						     +SectionOffset
						     +CompUnit->section_table
						     +DST_RECORD_HDR_SIZE,
					  L_SET) == -1) then
				    error("cannot seek to section table");

				if (read(TargetFile,&NumberOfSections,
					 sizeof(NumberOfSections))
					!= sizeof(NumberOfSections)) then
				    error("cannot read section table size");
				for (i=0; i<NumberOfSections; i++) do
				    begin
					if (read(TargetFile,&SectionBase,
						 sizeof(SectionBase))
						!= sizeof(SectionBase)) then
					    error("cannot read section \
						   base value");
					if (SectionBase < FirstChangedVaddr)
					    then continue;
					SectionBase += Delta;
					if (lseek(TargetFile,
						  -sizeof(SectionBase),
						  L_INCR) == -1) then
					    error("cannot seek to \
						   section base value");
					if (write(TargetFile,&SectionBase,
						  sizeof(SectionBase))
						!= sizeof(SectionBase)) then
					    error("cannot write section base");
				    end;
				SectionOffset += CompUnit->data_size;
			    end
			else error("unexpected dst record type");
		    end;
	    end;
	if (close(SourceFile) == -1) then
	    error("cannot close source file");
	if (close(TargetFile) == -1) then
	    error("cannot close target file");
    end


hidden CopyData(int TargetFile,
		int SourceFile,
		long TotalByteCount)
    begin
	unsigned char Buffer[4096];
	long ByteCount;
	while (TotalByteCount > 0) do
	    begin
		if (TotalByteCount > sizeof(Buffer)) then
		    ByteCount = sizeof(Buffer);
		else ByteCount = TotalByteCount;
		if (read(SourceFile,Buffer,ByteCount) != ByteCount) then
		    error("cannot read data");
		if (write(TargetFile,Buffer,ByteCount) != ByteCount) then
		    error("cannot write data");
		TotalByteCount -= ByteCount;
	    end;
    end
