(defvar inhibit-rename-screen nil "List of screens not to rename on select")
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;;; This uses an undocumented feature that SMK claims crashes Epoch.
;;; However, I "fixed" his code, and tested with the hook function being
;;; garbage-collect, and that seemed to work just fine.

(defun amc-set-name (win)
  (let*
    (
      (buff (window-buffer win))
      (name (or (and buff (buffer-name buff)) "# No-Name #") )
      (scr (epoch::screen-of-window win))
    )
    (if
      (and
	buff
	(buffer-file-name buff)
	(not (memq scr inhibit-rename-screen))
      )
      (progn (epoch::title name scr) (epoch::icon-name name scr))
    )
  )
)
(setq set-window-buffer-hook 'amc-set-name)
;;; --------------------------------------------------------------------------
(defun kill-entire-line ()
  (interactive)
  (save-excursion
    (beginning-of-line)
    (setq start (point))
    (end-of-line)
    (forward-char 1)
    (kill-region start (point))
  )
)

(defun kill-start-of-line ()
  (interactive)
  (let ( (there (point)) )
    (beginning-of-line)
    (kill-region (point) there)
  )
)

(defun kill-end-of-line () (interactive)
  (let ((there (point)))
    (end-of-line)
    (kill-region (point) there)
  )
)

(defun join-lines ()
  (interactive)
  (save-excursion
    (end-of-line)			;go the end
    (delete-char 1)			;get rid of the newline
    (just-one-space)			;remove all but one space
  )
)
;;; ----------------------------------------------------------------------
(defun scroll-process-output (process data)
  (princ data (process-mark process))
  (let ( (win (epoch::get-buffer-window (process-buffer process))) )
    (if (not (eq win (selected-window)))
      (set-window-point win (process-mark process))
    )
    (setq win-debug win)		;debug code
  )
)

(defun scroll-this-process-buffer ()
  (interactive)
  (set-process-filter
    (get-buffer-process (current-buffer)) 'scroll-process-output
  )
  (if (not epoch::global-update) (setq epoch::global-update t))
  (epoch::set-update t)
)
;;; --------------------------------------------------------------------------
;;; MH support
;;;
(defvar mh-screen nil)
(defun mh-set-up () (interactive)
  (if (and (screenp mh-screen) (get-screen-id mh-screen))
    (mapraised-screen mh-screen)
    (setq mh-screen
      (create-screen "*scratch*"
	'((geometry . "80x45-0-80") (icon-name . "MH-Mailer")
	  (title . "MH-Mailer")
	)
      )
    )
  )
  (or
    (memq mh-screen inhibit-rename-screen)
    (setq inhibit-rename-screen (cons mh-screen inhibit-rename-screen))
  )
  (on-map-do mh-screen
    (function (lambda (s) 
	(epoch::icon-name "MH-Mailer" mh-screen)
	(epoch::title "MH-Mailer" mh-screen)
	(select-screen mh-screen)
	(mh-rmail)
      ))))
;;; ------------------------------------------------------------------------
(defun iconify-everything () (interactive)
  (dolist (s (screen-list))
    (iconify-screen s)
  )
  (iconify-screen 0)
)
;;; ------------------------------------------------------------------------
(global-unset-key "\C-z")	     ; Let's change all the default bindings!

(global-set-key "\C-zf" 'find-file-other-screen)
(global-set-key "\C-zb" 'find-buffer-other-screen)
(global-set-key "\C-z\C-f" 'find-file-other-screen)
(global-set-key "\C-z\C-b" 'find-buffer-other-screen)
(global-set-key "\C-z0" 'delete-screen)
(global-set-key "\C-zi" (definteractive (iconify-screen)))
(global-set-key "\C-ze" 'display-event-status)
(global-set-key "\C-z\C-m" (definteractive (mapraised-screen 0)))

(defun my-exit-from-emacs () (interactive)
  (if (yes-or-no-p "Do you want to exit ")
    (save-buffers-kill-emacs)))

(global-set-key "\C-x\C-c" 'my-exit-from-emacs)

;;; This shouldn't actually do anything, but GWM seems to miss the title
;;; change events, so this gives it another chance.
(global-set-key "\C-za"
  (definteractive (title (title)) (icon-name (icon-name))))

(global-set-key "\M-g" 'goto-line)

;; line killing
(global-set-key "\C-l" 'kill-end-of-line)
(global-set-key "\C-k" 'kill-entire-line)
(global-set-key "\C-j" 'kill-start-of-line)

(global-unset-key "\C-x\C-u")		; what a dumb binding that was.

(global-set-key "\M-\C-l" (definteractive
    (add-change-log-entry nil "ChangeLog")))
