;;;
;;; My key bindings, inspired by Brief on my '386 box.
;;; Requires Epoch 3.2 (not beta!)
;;;

;; Function key mapping is to start with \C-^ as the first character.
;; This seems to not be used in the standard key maps.

;;; Function keys!
;; Praise the Lord and pass the ammunition!
;; This stuff here prevents the function keys from screwing up during search
;; and other minibuffer activities, as it does when for the default settings,
;; which have ESC as the first char.
;;
;; Conventions:
;; Rebound keys start with control-^.
;; Keypad keys are "k" followed by the keypad symbol.
;; Functions keys are the function letter ("r","l", or "f") followed by the
;; number mod 10. The letter is uppercase if the function number is >9.
;; letter use "_" followed by the letter.
;;
;; Modifiers are "S" for shift, "C" for control, "M" for meta, and "A" for alt.

;; Some of the following appear multiply defined, but that's because some keys
;; change keysym when shifted (stupid!), and there are differences between the
;; Sun-3 and sun-4 keyboards, so I just do both. Yay.
;; Additional changes are included so that the same file works on Sun3's,
;; Sparcs, and '386 boxes.
;;

;; special keys

(setq epoch::function-key-mapping nil)	;turn off ESC mapping for function keys

;;; Sun keyboard specials
(rebind-key "Help" 0 "\C-h")
(rebind-key "R6" 0 "\C-^r6")

;;; '386 bindings
(rebind-key "KP_Multiply" 0 "\C-^k*")
(rebind-key "KP_Subtract" 0 "\C-^k-")
(rebind-key "KP_Add" 0 "\C-^k+")
(rebind-key "BackSpace" 0 "\C-?")
(rebind-key "BackSpace" 'meta "\M-\C-?")

;;; General bindings

;;; Insert
(rebind-key "Insert" 0 "\C-^k0")
(rebind-key "Insert" 'meta "\C-^Mk0")

;;; Home
(rebind-key "Home" 0 "\C-^k7")
(rebind-key "R7" 0 "\C-^k7")
(rebind-key "Home" 'shift "\C-^Sk7")
(rebind-key "R7" 'shift "\C-^Sk7")
(rebind-key "KP_7" 'shift "\C-^Sk7")
(rebind-key "Home" 'control "\C-^Ck7")
(rebind-key "R7" 'control "\C-^Ck7")

;;; Up arrow
(rebind-key "Up" 0 "\C-^k8")
(rebind-key "R8" 'shift "\C-^Sk8")
(rebind-key "Up" 'shift "\C-^Sk8")
(rebind-key "KP_8" 'shift "\C-^Sk8")
(rebind-key "Up" 'control "\C-^Ck8")
(rebind-key "Up" 'meta "\C-^Mk8")

;;; Page Up
(rebind-key "Prior" 0 "\C-^k9")
(rebind-key "R9" 0 "\C-^k9")
(rebind-key "Prior" 'shift "\C-^Sk9")
(rebind-key "R9" 'shift "\C-^Sk9")
(rebind-key "KP_9" 'shift "\C-^Sk9")
(rebind-key "Prior" 'control "\C-^Ck9")
(rebind-key "R9" 'control "\C-^Ck9")
(rebind-key "Prior" 'meta "\C-^Mk9")
(rebind-key "R9" 'meta "\C-^Mk9")

;;; Left arrow
(rebind-key "Left" 0 "\C-^k4")
(rebind-key "R10" 'shift "\C-^Sk4")
(rebind-key "Left" 'shift "\C-^Sk4")
(rebind-key "KP_4" 'shift "\C-^Sk4")
(rebind-key "Left" 'meta "\C-^Mk4")
(rebind-key "Left" 'control "\C-^Ck4")

;;; keypad center
(rebind-key "R11" 0 "\C-^k5")
(rebind-key "KP_5" 0 "\C-^k5")
(rebind-key "R11" 'control "\C-^Ck5")
(rebind-key "KP_5" 'control "\C-^Ck5")

;;; right arrow
(rebind-key "Right" 0 "\C-^k6")
(rebind-key "R12" 'shift "\C-^Sk6")
(rebind-key "Right" 'shift "\C-^Sk6")
(rebind-key "KP_6" 'shift "\C-^Sk6")
(rebind-key "Right" 'control "\C-^Ck6")
(rebind-key "Right" 'meta "\C-^Mk6")

;;; end
(rebind-key "End" 0 "\C-^k1")
(rebind-key "R13" 0 "\C-^k1")
(rebind-key "R13" 'shift "\C-^Sk1")
(rebind-key "KP_1" 'shift "\C-^Sk1")
(rebind-key "End" 'control "\C-^Ck1")
(rebind-key "R13" 'control "\C-^Ck1")

;;; Down arrow
(rebind-key "Down" 0 "\C-^k2")
(rebind-key "R14" 'shift "\C-^Sk2")
(rebind-key "Down" 'shift "\C-^Sk2")
(rebind-key "KP_2" 'shift "\C-^Sk2")
(rebind-key "Down" 'control "\C-^Ck2")
(rebind-key "Down" 'meta "\C-^Mk2")

;;; Page Down
(rebind-key "R15" 0 "\C-^k3")
(rebind-key "Next" 0 "\C-^k3")
(rebind-key "R15" 'shift "\C-^Sk3")
(rebind-key "Next" 'shift "\C-^Sk3")
(rebind-key "KP_3" 'shift "\C-^Sk3")
(rebind-key "Next" 'control "\C-^Ck3")
(rebind-key "R15" 'control "\C-^Ck3")
(rebind-key "Next" 'meta "\C-^Mk3")
(rebind-key "R15" 'meta "\C-^Mk3")

;;; Extra modifiers on standard keys
(rebind-key "equal" 'control "\C-^C=")
(rebind-key "equal" 'mod3 "\C-^A=")
(rebind-key "minus" 'control "\C-^C-")
(rebind-key "minus" 'mod3 "\C-^A-")
;;; -------------------------------------------------------------------------
;;; Now, the bindings to function
;;;

(global-set-key "\C-^r6" 'undo)		; keypad * on new suns
(global-set-key "\C-^k*" 'undo)		; keypad * on '386
(global-set-key "\C-^k0" 'yank)		; insert
(global-set-key "\C-^Mk0" 'yank-pop)	; Meta-insert

;; Normal cursor keys move characters and lines
(global-set-key "\C-^k8" 'previous-line) ; up arrow
(global-set-key "\C-^k2" 'next-line)	; down arrow
(global-set-key "\C-^k4" 'backward-char) ; left arrow
(global-set-key "\C-^k6" 'forward-char)	; right arrow

;; Shifted horizontal goes words
(global-set-key "\C-^Sk6" 'forward-word) ; shift right arrow
(global-set-key "\C-^Sk4" 'backward-word) ; shift left arrow
(global-set-key "\C-^Sk8" (definteractive (scroll-down 1))) ; shift up arrow
(global-set-key "\C-^Sk2" (definteractive (scroll-up 1))) ; shift down arrow

;; control page switches screens
(global-set-key "\C-^Ck9"
  (definteractive (select-screen (raise-screen (next-screen))))
)
					;control page-up
(global-set-key "\C-^Ck3"
  (definteractive (select-screen (raise-screen (prev-screen))))
)
					;control page-down

(global-set-key "\C-^Ck8" (definteractive (select-window (next-window))))
					;control up arrow
(global-set-key "\C-^Ck2" (definteractive (select-window (previous-window))))
					;control down arrow
(global-set-key "\C-^Sk9" (definteractive (raise-screen))) ;shift page-up
(global-set-key "\C-^Sk3" (definteractive (lower-screen))) ;shift page-down

;;;
(global-set-key "\C-^k7" 'beginning-of-line) ; Home
(global-set-key "\C-^k5" 'recenter)	; Center
(global-set-key "\C-^k1" 'end-of-line)	; End
(global-set-key "\C-^Ck7" 'beginning-of-buffer)	; control Home
(global-set-key "\C-^Ck1" 'end-of-buffer) ; control End
(global-set-key "\C-^Ck5" 'exchange-point-and-mark) ; control center

(global-set-key "\C-^C=" 'split-window-vertically) ;control =
(global-set-key "\C-^C-" 'delete-other-windows)	;control -

(global-set-key "\C-^k9" 'scroll-down)	; Page Up
(global-set-key "\C-^k3" 'scroll-up)	; Page Down

;;; --------------------------------------------------------------------------
;;; Line manipulation stuff

(defun set-region-lines (count)
"Set the region to be COUNT lines, including the current line"
  (or (numberp count) (setq count 1))
  (cond
    ((< count 0)
      (forward-line 1)
      (push-mark (point) t)
    )
    (t
      (beginning-of-line)
      (push-mark (point) t)
    )
  )
  (forward-line count)
)

(global-set-key "\C-^k+"
  (function (lambda (count) (interactive "pCount: ")
      (save-excursion
	(set-region-lines count)
	(copy-region-as-kill (point) (mark))
	(pop-mark)
      )
    )
  )
)

(global-set-key "\C-^k-"
  (function (lambda (count) (interactive "pCount: ")
      (save-excursion
	(set-region-lines count)
	(kill-region (point) (mark))
	(pop-mark)
      )
    )
  )
)
