;;;
;;; Placement stuff for Epoch to put screens in useful places.
;;;
(defvar screen-x-delta 15 "Amount to move to put the next screen")
(defvar screen-y-delta 25 "Amount to move to put the next screen")
(defvar init-screen-x screen-x-delta "Location of the next screen")
(defvar init-screen-y screen-y-delta "Location of the next screen")
(defvar init-screen-height (screen-height) "Height of screen in characters")
(defvar init-screen-width (screen-width) "Width of screen in characters")
(defvar max-init-screen-x (elt (epoch::plane-size) 0))
;(defvar max-init-screen-x 640)		;for panning display
(defvar max-init-screen-y (- (cdr (epoch::plane-size)) 96))
;  (- (elt (epoch::screen-information (minibuf-screen)) 1) 100)
;)

(defun amc-alist-hook (alist)
  (let*
    (
      (geom (assq 'geometry alist))
      (spec (cdr geom))
      (loc (format "+%d+%d" init-screen-x init-screen-y))
      (width init-screen-width)
      (height init-screen-height)
      (size (format "%dx%d" init-screen-width init-screen-height))
      (result alist)
      x-size y-size
    )
    (cond
      ((null geom)
	(setq result (cons (cons 'geometry (concat size loc)) alist))
      )
      ((string-match "[0-9]+x\\([0-9]\\)+$" spec) ;size, no location
	(setcdr geom (concat spec loc)) ;add my location
	(setq width (string-to-int spec))
	(setq height
	  (string-to-int (substring spec (match-beginning 1) (match-end 1)))
	)
      )
    )
    ;; Now, update internal stuff
    (setq x-size (* width (elt (epoch::font) 1)))
    (setq y-size (* height (elt (epoch::font) 2)))
    (setq init-screen-x
      (mod (+ init-screen-x screen-x-delta) (- max-init-screen-x x-size))
    )
    (setq init-screen-y
      (mod (+ init-screen-y screen-y-delta) (- max-init-screen-y y-size))
    )
    ;; return new alist
    result
  )
)
;;;
;;; want this to run _last_.
(setq *create-screen-alist-hook*
  (append (delq 'amc-alist-hook *create-screen-alist-hook*) '(amc-alist-hook))
)
