;;;
;;; epoch-thing.el
;;;
;;; Adds mouse support to existing 'thing' code
;;;
;;; Written by Dan L. Pierson, pierson@encore.com
;;;
;;; Shift-mouse drag will now grab entire "thing" containing
;;; mouse coordinate.
;;; Control-mouse drag will grab entire sexp containing
;;; mouse coordinate.
;;; (See mouse bindings as installed below)
;;;
(require 'thing)

(global-set-mouse mouse-left mouse-control 'mouse-drag-sexp)
(global-set-mouse mouse-left mouse-control-up 'end-mouse-drag)

(global-set-mouse mouse-left mouse-shift 'mouse-drag-thing)
(global-set-mouse mouse-left mouse-shift-up 'end-mouse-drag)

(defun mouse-copy-thing (arg)
  (let (string)
    (save-excursion
      (set-buffer (nth 1 arg))
      (let* ((point (car arg))
	     (place (thing-boundaries point))
	     (start (car place))
	     (end (cdr place)))
	(if (save-excursion (goto-char end) (eolp))
	    (setq end (+ 1 end)))
	(setq string (buffer-substring start end))))
    (insert-string string))
  (epoch::redisplay-screen))
(global-set-mouse mouse-middle mouse-shift 'mouse-copy-thing)
(global-set-mouse mouse-middle mouse-shift-up 'end-mouse-drag)

(defun mouse-kill-thing (arg &optional supress-redisplay)
  "Kill text object at mouse position and insert into window system cut buffer.
Save in Emacs kill ring also."
  (save-excursion
    (set-buffer (nth 1 arg))
    (let* ((point (car arg))
	   (bounds (thing-boundaries point))
	   (start (car bounds))
	   (end (cdr bounds)))
      (epoch::store-cut-buffer (buffer-substring start end))
      (copy-region-as-kill start end)
      (delete-region start end))
    (epoch::redisplay-screen)))
(global-set-mouse mouse-right mouse-shift 'mouse-kill-thing)
(global-set-mouse mouse-right mouse-shift-up 'end-mouse-drag)





