;;
;; dot.emacs - do any epoch-dependent processing here
;;
;; running-epoch is a better name for the variable that tells us is we are
;; in epoch or not
(defvar running-epoch (boundp 'epoch::version))

(if running-epoch (setq term-file-prefix nil)) ; don't load xterm stuff!
(setq target-buffer (get-buffer "*scratch*"))

(put 'eval-expression 'disabled nil)

;; because I have so many screens open all the time, and idle C-xC-c can
;; really screw things up for me.  So make sure we dont exit without
;; confirmation, and rebind C-xC-c appropriately

(defun my-exit-from-emacs ()
  (interactive)
  (if (yes-or-no-p "Do you want to exit ")
      (save-buffers-kill-emacs)))

(global-set-key "\C-x\C-c" 'my-exit-from-emacs)

;;
;; Load epoch elisp code.  Most/all of this should have been loaded at the
;; time epoch was dumped.  Load any of these files if necessary.  Change
;; these "require" statements to "load-file" to pick up local changes to 
;; standard code that was dumped.
;;
(if running-epoch
  (progn
    (require 'mini-cl)
    (require 'wrapper)
    (require 'epoch-util)
    (require 'epoch)	
    (require 'event)
    (require 'button)
    (require 'mouse)
    (require 'motion)
    (require 'property)
    (require 'message)
    (require 'server)		;; not dumped - this will always load
  )
)
