(defun fix-query (prompt)
  (let ( (chr 'continue) )
    (while (eq chr 'continue)
      (message "%s" prompt)
      (setq chr (read-char))
      (cond
	((or (= chr ?y) (= chr ? )) (setq chr t))
	((or (= chr ?n) (= chr ?\177)) (setq chr nil))
	((= chr ?\e) (setq chr 'abort))
	(t (message "Please answer y or n") (sit-for 1) (setq chr 'continue))
      )
    )
    chr
  )
)
;;;
(defun button-query-replace (from to-func)
"Query-replace with button highlighting. FROM is the regular expression to
search for, and TO-FUNC is a function that is called to generate the 
replacement string (it should use the match data to generate this)"
  (save-excursion
    (goto-char (point-min))
    (let ( b (continue t))
      (while (re-search-forward from nil t)
	(unwind-protect
	  ;;BODY
	  (progn
	    (setq b (epoch::add-button (match-beginning 0) (match-end 0) 1))
	    (let*
	      (
		(replacement (funcall to-func))
		(answer (fix-query (concat "Change to \"" replacement "\"? ")))
	      )
	      (cond
		((eq answer t) (replace-match replacement t t))
		((null answer) )	;nothing
		(answer			;not t or nil, abort!
		  (goto-char (point-max)) ;get out of loop
		  (setq continue nil)
		)
	      )
	    )
	  )
	  ;;CLEAN-UP
	  (when (and (boundp 'b) b)	(epoch::delete-button b))
	)
      )
      continue
    )
  )
)
;;;
(defun fix-aref-3-2 (index new-func)
  (prog1
    (button-query-replace
      (concat "(aref \\(\\s_\\|\\w\\)+ " (int-to-string index) "[ \t]*)")
      (`
	(lambda ()
	  (concat "(" (, new-func) " "
	    (buffer-substring (match-beginning 1) (match-end 1))
	    ")"
	  )
	)
      )
    )
    (undo-boundary)
  )
)
;;;
(defun fix-aset-3-2 (index new-func)
  (prog1
    (button-query-replace
      (concat "(aset \\(\\s_\\|\\w\\)+ " (int-to-string index) "\\([) \t]\\)")
      (`
	(lambda ()
	  (concat "(" (, new-func) " "
	    (buffer-substring (match-beginning 1) (match-end 1))
	    (buffer-substring (match-beginning 2) (match-end 2))
	  )
	)
      )
    )
    (undo-boundary)
  )
)
;;;
(defun fix3-2 ()
  (and
    (fix-aref-3-2 0 "epoch::button-start")
    (fix-aref-3-2 1 "epoch::button-end")
    (fix-aref-3-2 2 "epoch::button-attribute")
    (fix-aref-3-2 3 "epoch::button-data")
    (fix-aset-3-2 2 "epoch::set-button-attribute")
    (fix-aset-3-2 3 "epoch::set-button-data")
  )
)
