;;; Copyright (C) 1990  Christopher J. Love
;;;
;;; This file is for use with Epoch, a modified version of GNU Emacs.
;;; Requires Epoch 3.2 or later.
;;;
;;; This code is distributed in the hope that it will be useful,
;;; bute WITHOUT ANY WARRANTY. No author or distributor accepts
;;; responsibility to anyone for the consequences of using this code
;;; or for whether it serves any particular purpose or works at all,
;;; unless explicitly stated in a written agreement.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this code, but only under the conditions described in the
;;; GNU Emacs General Public License, except the original author nor his
;;; agents are bound by the License in their use of this code.
;;; (These special rights for the author in no way restrict the rights of
;;;  others given in the License or this prologue)
;;; A copy of this license is supposed to have been given to you along
;;; with Epoch so you can know your rights and responsibilities. 
;;; It should be in a file named COPYING.  Among other things, the
;;; copyright notice and this notice must be preserved on all copies. 
;;;

;;;
;;; wrapper.el - define "wrappers" for all epoch:: functions
;;;
(provide 'wrapper)

(fset 'redisplay-screen (symbol-function 'epoch::redisplay-screen))
(fset 'set-screen-modified (symbol-function 'epoch::set-screen-modified))
(fset 'next-screen (symbol-function 'epoch::next-screen))
(fset 'prev-screen (symbol-function 'epoch::prev-screen))
(fset 'current-screen (symbol-function 'epoch::current-screen))
(fset 'minibuf-screen (symbol-function 'epoch::minibuf-screen))
(fset 'raise-screen (symbol-function 'epoch::raise-screen))
(fset 'lower-screen (symbol-function 'epoch::lower-screen))
(fset 'map-screen (symbol-function 'epoch::map-screen))
(fset 'background (symbol-function 'epoch::background))
(fset 'foreground (symbol-function 'epoch::foreground))
(fset 'cursor-color (symbol-function 'epoch::cursor-color))
(fset 'cursor-glyph (symbol-function 'epoch::cursor-glyph))
(fset 'set-update (symbol-function 'epoch::set-update))
(fset 'update-p (symbol-function 'epoch::update-p))
(fset 'icon-name (symbol-function 'epoch::icon-name))
(fset 'title (symbol-function 'epoch::title))
(fset 'screenp (symbol-function 'epoch::screen-p))
(fset 'screen-p (symbol-function 'epoch::screen-p))
(fset 'screen-of-window (symbol-function 'epoch::screen-of-window))
(fset 'screens-of-buffer (symbol-function 'epoch::screens-of-buffer))
(fset 'get-screen (symbol-function 'epoch::get-screen))
(fset 'get-screen-id (symbol-function 'epoch::get-screen-id))
; for compatibility (next 2)
(fset 'epoch::make-id (symbol-function 'epoch::get-screen-id))
(fset 'epoch::make-screen (symbol-function 'epoch::get-screen))
;
(fset 'font (symbol-function 'epoch::font))
(fset 'query-mouse (symbol-function 'epoch::query-mouse))
(fset 'query-pointer (symbol-function 'epoch::query-pointer))
(fset 'query-cursor (symbol-function 'epoch::query-cursor))
(fset 'warp-mouse (symbol-function 'epoch::warp-mouse))
(fset 'warp-pointer (symbol-function 'epoch::warp-pointer))
(fset 'coords-to-point (symbol-function 'epoch::coords-to-point))
(fset 'screen-list (symbol-function 'epoch::screen-list))
(fset 'move-screen (symbol-function 'epoch::move-screen))
(fset 'mapraised-screen (symbol-function 'epoch::mapraised-screen))
(fset 'screen-information (symbol-function 'epoch::screen-information))
(fset 'plane-size (symbol-function 'epoch::plane-size))
(fset 'screen-mapped-p (symbol-function 'epoch::screen-mapped-p))
(fset 'change-screen-size (symbol-function 'epoch::change-screen-size))

(fset 'intern-atom (symbol-function 'epoch::intern-atom))
(fset 'unintern-atom (symbol-function 'epoch::unintern-atom))
(fset 'resourcep (symbol-function 'epoch::resourcep))
(fset 'string-to-resource (symbol-function 'epoch::string-to-resource))
(fset 'resource-to-string (symbol-function 'epoch::resource-to-string))
(fset 'resource-to-type (symbol-function 'epoch::resource-to-type))
(fset 'set-resource-type (symbol-function 'epoch::set-resource-type))
(fset 'get-property (symbol-function 'epoch::get-property))
(fset 'set-property (symbol-function 'epoch::set-property))
(fset 'send-client-message (symbol-function 'epoch::send-client-message))
(fset 'xid-of-screen (symbol-function 'epoch::xid-of-screen))
(fset 'query-tree (symbol-function 'epoch::query-tree))
(fset 'rebind-key (symbol-function 'epoch::rebind-key))
(fset 'mod-to-shiftmask (symbol-function 'epoch::mod-to-shiftmask))

(fset 'get-font (symbol-function 'epoch::get-font))

(fset 'flash-screen (symbol-function 'epoch::flash-screen))
(fset 'set-bell (symbol-function 'epoch::set-bell))

(fset 'move-button (symbol-function 'epoch::move-button))
(fset 'make-button (symbol-function 'epoch::make-button))
(fset 'button-attribute (symbol-function 'epoch::button-attribute))
(fset 'button-data (symbol-function 'epoch::button-data))
(fset 'button-start (symbol-function 'epoch::button-start))
(fset 'button-end (symbol-function 'epoch::button-end))
(fset 'button-at (symbol-function 'epoch::button-at))
(fset 'buttons-at (symbol-function 'epoch::buttons-at))
(fset 'delete-button (symbol-function 'epoch::delete-button))
(fset 'delete-button-at (symbol-function 'epoch::delete-button-at))
(fset 'buttonp (symbol-function 'epoch::buttonp))
(fset 'button-list (symbol-function 'epoch::button-list))
(fset 'read-only-region-p (symbol-function 'epoch::read-only-region-p))
(fset 'button-buffer (symbol-function 'epoch::button-buffer))
(fset 'set-button-attribute (symbol-function 'epoch::set-button-attribute))
(fset 'set-button-data (symbol-function 'epoch::set-button-data))
(fset 'button-read-only-p (symbol-function 'epoch::button-read-only-p))
(fset 'set-button-read-only (symbol-function 'epoch::set-button-read-only))
(fset 'clear-buttons (symbol-function 'epoch::clear-buttons))
(fset 'number-of-colors (symbol-function 'epoch::number-of-colors))
(fset 'get-color (symbol-function 'epoch::get-color))
(fset 'free-color (symbol-function 'epoch::free-color))
;;;
(fset 'make-style (symbol-function 'epoch::make-style))
(fset 'attribute-style (symbol-function 'epoch::attribute-style))
(fset 'set-attribute-style (symbol-function 'epoch::set-attribute-style))
(fset 'style-foreground (symbol-function 'epoch::style-foreground))
(fset 'style-background (symbol-function 'epoch::style-background))
(fset 'style-cursor-foreground (symbol-function 'epoch::style-cursor-foreground))
(fset 'style-cursor-background (symbol-function 'epoch::style-cursor-background))
(fset 'style-underline (symbol-function 'epoch::style-underline))
(fset 'style-font (symbol-function 'epoch::style-font))
(fset 'style-stipple (symbol-function 'epoch::style-stipple))
(fset 'style-cursor-stipple (symbol-function 'epoch::style-cursor-stipple))
(fset 'style-background-stipple (symbol-function 'epoch::style-background-stipple))
(fset 'set-style-foreground (symbol-function 'epoch::set-style-foreground))
(fset 'set-style-background (symbol-function 'epoch::set-style-background))
(fset 'set-style-cursor-foreground (symbol-function 'epoch::set-style-cursor-foreground))
(fset 'set-style-cursor-background (symbol-function 'epoch::set-style-cursor-background))
(fset 'set-style-underline (symbol-function 'epoch::set-style-underline))
(fset 'set-style-font (symbol-function 'epoch::set-style-font))
(fset 'set-style-stipple (symbol-function 'epoch::set-style-stipple))
(fset 'set-style-cursor-stipple (symbol-function 'epoch::set-style-cursor-stipple))
(fset 'set-style-background-stipple (symbol-function 'epoch::set-style-background-stipple))
;;;
(fset 'make-bitmap (symbol-function 'epoch::make-bitmap))
(fset 'free-bitmap (symbol-function 'epoch::free-bitmap))