/* GNU Emacs site configuration template file.
   Copyright (C) 1988 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/* Include here a s- file that describes the system type you are using.
   See the file ../etc/MACHINES for a list of systems and
   the names of the s- files to use for them.
   See s-template.h for documentation on writing s- files.  */
#include "s-sunos4.h"

/* Include here a m- file that describes the machine and system you use.
   See the file ../etc/MACHINES for a list of machines and
   the names of the m- files to use for them.
   See m-template.h for info on what m- files should define.
   */
#include "m-sparc.h"

/* Load in the conversion definitions if this system
   needs them and the source file being compiled has not
   said to inhibit this.  There should be no need for you
   to alter these lines.  */

#ifdef SHORTNAMES
#ifndef NO_SHORTNAMES
#include "../shortnames/remap.h"
#endif /* not NO_SHORTNAMES */
#endif /* SHORTNAMES */

/* Define HAVE_X_WINDOWS if you want to use the X window system.  */

#define HAVE_X_WINDOWS

/* Define X11 if you want to use version 11 of X windows.
   Otherwise, Emacs expects to use version 10.  */

#define X11

/* Define HAVE_X_MENU if you want to use the X window menu system.
   This appears to work on some machines that support X
   and not on others.  */

/* #define HAVE_X_MENU */

/* Define `subprocesses' should be defined if you want to
   have code for asynchronous subprocesses
   (as used in M-x compile and M-x shell).
   These do not work for some USG systems yet;
   for the ones where they work, the s-*.h file defines this flag.  */

#ifndef VMS
#ifndef USG
#define subprocesses
#endif
#endif

/* Define USER_FULL_NAME to return a string
   that is the user's full name.
   It can assume that the variable `pw'
   points to the password file entry for this user.

   At some sites, the pw_gecos field contains
   the user's full name.  If neither this nor any other
   field contains the right thing, use pw_name,
   giving the user's login name, since that is better than nothing.  */

#define USER_FULL_NAME pw->pw_gecos

/* Define AMPERSAND_FULL_NAME if you use the convention
   that & in the full name stands for the login id.  */

/* #define AMPERSAND_FULL_NAME */

/* Maximum screen width we handle. */

#define MScreenWidth 300

/* Maximum screen length we handle. */

#define MScreenLength 300

/* # bytes of pure Lisp code to leave space for.
   Note that s-vms.h and m-sun2.h may override this default.  */

#ifndef PURESIZE
#ifdef HAVE_X_WINDOWS
#define PURESIZE 200000
#else
#define PURESIZE 118000
#endif
#endif

/* Define HIGHPRI as a negative number
   if you want Emacs to run at a higher than normal priority.
   For this to take effect, you must install Emacs with setuid root.
   Emacs will change back to the users's own uid after setting
   its priority.  */

/* #define HIGHPRI */

/* These are fixes to the gap moving code. The normal setup is to use while
 * loops to move the gap. bcopy() can't be used normally because the regions
 * might overlap. The following control this. If 0, then a while loop is used.
 * non-0 indicates that bcopy() should be used. RIGHT_OVERLAP means that
 * _target_ area overlaps the _source_ area on the right of the _source_,
 * i.e. _target_ > _source_. LEFT_OVERLAP is the opposite, the _target_
 * overlaps the _source_ on the left, _source_ > _target_.
 */
#ifndef SAFE_BCOPY_RIGHT_OVERLAP
#define SAFE_BCOPY_RIGHT_OVERLAP 0
#endif
#ifndef SAFE_BCOPY_LEFT_OVERLAP
#define SAFE_BCOPY_LEFT_OVERLAP 0
#endif

/* for those systems that don't support void *'s, change void to char */
#define VOID void

/* define DENYS_ALARM if you want timer events. they are implemented
 * by sharing the real timer with emacs. see alarm.c.
 */

/* #define DENYS_ALARM  */

/* define DENYS_MOTION_COMPRESSION if you want code that implements
 * motion events compression. nobody knows yet if this is useful.
 */

/* #define DENYS_MOTION_COMPRESSION */

/* define ALL_MOTIONS to receive motion events whenever they occur.
 * otherwise, you will only receive motion events while a button is
 * pressed.
 */

/* #define ALL_MOTIONS */

/*
 * define HAVE_LEIF if you wish to use epoch with the Leif package, or
 * with to use the before and after-change hooks.
 */

/* #define HAVE_LEIF */

/*
 * define X_COMPOSE if you wish to utilize X support for Compose strings.
 * This is enabled in sun-os4.h
 */

/* #define X_COMPOSE */
