#include <stdio.h>
#include <fcntl.h>
#include <pixrect/pixrect_hs.h>

#define MAX_COLOR	256
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void FatalError(s)
char *s;
    {
    fprintf(stderr,"%s\n",s);
    exit(1);
    }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int colors_used(image,used)
	struct pixrect *image;
	unsigned char *used;
    {
    int i;
    int x,y;
    int width = image->pr_size.x,height = image->pr_size.y;
    int color;
    int count = 0;

    for ( i = 0 ; i < MAX_COLOR ; ++i ) used[i] = 0;

    for ( y = 0 ; y < height ; ++y )
	for ( x = 0 ; x < width ; ++x )
	    {
	    color = pr_get(image,x,y);
	    if (!used[color]) { ++count; used[color] = 1; }
	    }
    return count;
    }
    
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
main(argc,argv)
int argc;
char **argv;
    {
    int n_color;
    FILE *input,*output;
    int i;
    struct rasterfile R;
    colormap_t cmap;
    struct pixrect *image,*pr_load_image(),*region;
    unsigned char *malloc();
    unsigned char used[MAX_COLOR];

    if (argc < 2) FatalError("Need a file name, putz!");

    input = fopen(argv[1],"r");
    if (input == NULL) FatalError("Couldn't open file");


    if (pr_load_header(input,&R)) FatalError("Couldn't load header");
    printf("Image has depth %d, with %d colors, and is %d by %d\n",
	   R.ras_depth,R.ras_maplength/3,R.ras_width,R.ras_height);
    n_color = R.ras_maplength/3;
    cmap.type = R.ras_maptype;
    cmap.length = R.ras_maplength;
    cmap.map[0] = malloc(n_color);
    cmap.map[1] = malloc(n_color);
    cmap.map[2] = malloc(n_color);
    if (pr_load_colormap(input,&R,&cmap))
	FatalError("Couldn't read color map");

    image = pr_load_image(input,&R,&cmap);
    if (image == NULL) FatalError("Couldn't load pixrect");
    printf("Used %d colors\n",colors_used(image,used));
    }

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
