/* This file contains changes made by Data General, July 1990. */

/* m- file for Data General 88k series computers running DG/UX
   Copyright (C) 1985, 1986 Free Software Foundation, Inc.

   modified by David J. Biesack,
   modified by Michael Meissner,  meissner@dg-rtp.dg.com


This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/* Defined to be the libraries that are needed by default on this
   machine.  */

#ifdef FIX_ADDRESS
#define LIBS_MACHINE dgux-88k-addr-fix
#endif


/* The following three symbols give information on
 the size of various data types.  */

#define SHORTBITS 16		/* Number of bits in a short */

#define INTBITS 32		/* Number of bits in an int */

#define LONGBITS 32		/* Number of bits in a long */

/* Define BIG_ENDIAN iff lowest-numbered byte in a word
   is the most significant byte.  */

#define BIG_ENDIAN

/* Define how to take a char and sign-extend into an int.
   On machines where char is signed, this is a no-op.  */

#define SIGN_EXTEND_CHAR(c) (c)

/* Define DATA_SEG_BITS if pointers need to be corrected with
   a segment field.  */

#ifdef FIX_ADDRESS
#define DATA_SEG_BITS 0xef000000
#endif

/* Define NO_ARG_ARRAY if you cannot take the address of the first of a
 * group of arguments and treat it as an array of the arguments.  */

#define NO_ARG_ARRAY

/* Define WORD_MACHINE if addresses and such have
 * to be corrected before they can be used as byte counts.  */

#define WORD_MACHINE

/* Now define a symbol for the cpu type, if your compiler
   does not define it automatically:
   Ones defined so far include vax, m68000, ns16000, pyramid,
   orion, tahoe, APOLLO and many others */


/* Say this machine is a 88000 */

#ifndef m88k
#define m88k	1
#endif

/* Use type int rather than a union, to represent Lisp_Object */
/* This is desirable for most machines.  */

#define NO_UNION_TYPE

/* Define CANNOT_DUMP on machines where unexec does not work.
   Then the function dump-emacs will not be defined
   and temacs will do (load "loadup") automatically unless told otherwise.  */

/* #define CANNOT_DUMP */

/* Define UNEXEC to be the routine that supplies dump-emacs if the standard
   one is not used. */

/* #define UNEXEC */

/* Define VIRT_ADDR_VARIES if the virtual addresses of
   pure and impure space as loaded can vary, and even their
   relative order cannot be relied on.

   Otherwise Emacs assumes that data space precedes text space,
   numerically.  */

/* #define VIRT_ADDR_VARIES */

/* Define NO_REMAP if you do not want to try to save Emacs's pure
   data areas as part of the text segment.

   Saving them as text is good because it allows users to share more.

   However, on machines that locate the text area far from the data
   area, the boundary cannot feasibly be moved.  Such machines require
   NO_REMAP. */

#define NO_REMAP

/* Some machines that use COFF executables require that each section
   start on a certain boundary *in the COFF file*.  Such machines should
   define SECTION_ALIGNMENT to a mask of the low-order bits that must be
   zero on such a boundary.  This mask is used to control padding between
   segments in the COFF file.

   If SECTION_ALIGNMENT is not defined, the segments are written
   consecutively with no attempt at alignment.  This is right for
   unmodified system V.  */

#define SECTION_ALIGNMENT 0x7

/* Some machines require that the beginnings and ends of segments
   *in core* be on certain boundaries.  For most machines, a page
   boundary is sufficient.  That is the default.  When a larger
   boundary is needed, define SEGMENT_MASK to a mask of
   the bits that must be zero on such a boundary.  */

/* #define SEGMENT_MASK 0x0003FFFF */

/* Some machines count the a.out header as part of the size of the text
   segment (a_text); they may actually load the header into core as the
   first data in the text segment.  Some have additional padding between
   the header and the real text of the program that is counted in a_text.

   For these machines, define A_TEXT_OFFSET(HDR) to examine the header
   structure HDR and return the number of bytes to add to `a_text'
   before writing it (above and beyond the number of bytes of actual
   program text).  HDR's standard fields are already correct, except that
   this adjustment to the `a_text' field has not yet been made;
   thus, the amount of offset can depend on the data in the file. */

/* #define A_TEXT_OFFSET(HDR) */

/* If A_TEXT_SEEK is defined, this macro specifies the number of bytes
   to seek into the a.out file before starting to write the text
   segment.  */

/* #define A_TEXT_SEEK(HDR) */

/* For machines using COFF, this macro, if EXEC_MAGIC is defined, is a
   value stored into the magic number field of the output file. */

/* #define EXEC_MAGIC */

/* The ADJUST_EXEC_HEADER macro can be used to generate statements to
   adjust or initialize nonstandard fields in the file header.  */

/* #define ADJUST_EXEC_HEADER */

/* Define ADDR_CORRECT(ADDR) to be a macro to correct an int which is
   the bit pattern of a pointer to a byte into an int which is the
   number of a byte.

   This macro has a default definition which is usually right.
   This default definition is a no-op on most machines (where a
   pointer looks like an int) but not on all machines. */

#define	ADDR_CORRECT(ADDR) ((int)ADDR)


/* Cast pointers to this type to compare them.  Some machines want int.  */
/* For DG, use char * to canonicalize the pointer format. */

#define	PNTR_COMPARISON_TYPE	char *

/* Define C_ALLOCA if this machine does not support a true alloca
   and the one written in C should be used instead.
   Define HAVE_ALLOCA to say that the system provides a properly
   working alloca function and it should be used.
   Define neither one if an assembler-language alloca
   in the file alloca.s should be used.  */

#ifdef __GNUC__
#define HAVE_ALLOCA
#define alloca __builtin_alloca

#else
#define C_ALLOCA
#endif

/* Defines to work around not having full berkley functionality */

#define _setjmp		setjmp
#define	_longjmp	longjmp


