/* This file contains changes made by Data General, July 1990. */

/* s-dgux-4.20.h -- define parameters for 
   Data General's DG/UX 4.30 for the AViiON

   Copyright (C) 1989 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/*
 *	Define symbols to identify the version of Unix this is.
 *	Define all the symbols that apply correctly.
 */

/* #define UNIPLUS */
/* #define USG5 */
/* #define USG */
/* #define HPUX */
/* #define UMAX */
/* #define BSD4_1 */
#define BSD4_2
#define BSD4_3
#define BSD
/* #define VMS */

#ifdef emacs
#include <stdlib.h>		/* get builtins if they exist */
#include <string.h>
#include <ctype.h>
#endif


/* Define macros to say this is DG/UX if they are not already defined.  */

#ifndef DGUX
#define DGUX
#endif

#define DGUX_REV_4
#define DGUX_REV_4_10
#define DGUX_REV_4_20
#define DGUX_REV_4_30

/* Override some defaults in building emacs.  Do not optimize
   unless you are running GCC 1.35.20 or later!  */

#ifdef m88k
#define C_DEBUG_SWITCH -g -W -O
#define CC_PROGRAM gcc
#define LD_SWITCH_SYSTEM -L/usr/lib/X11
#define LIBS_STANDARD /usr/lib/gcc/gcc-gnulib -lc
#endif

/* Use the Berkeley flavors of the library routines, instead of System V.  */
#define setpgrp		setpgrp2
#define getpgrp		getpgrp2


/* Define C_ALLOCA to use the portable (and slow) C version of
   alloca.  Define HAVE_ALLOCA if alloca is available in the
   library.  */

#if defined(__GNUC__)
#define alloca __builtin_alloca
#define HAVE_ALLOCA

#elif defined(_MV)
#ifdef emacs
$builtin char *alloca();
#endif
#define HAVE_ALLOCA

#else
#define C_ALLOCA
#define HAVE_ALLOCA
#endif


/* SYSTEM_TYPE should indicate the kind of system you are using.
 It sets the Lisp variable system-type.  */

#define SYSTEM_TYPE "dgux-4.30"


/* Define SYSTEM_MALLOC to use the system's malloc and alloca. */

#ifdef _MV
#define SYSTEM_MALLOC
#endif

/* Use TERMINFO instead of termcap */

#define	TERMINFO


/* NOMULTIPLEJOBS should be defined if your system's shell
 does not have "job control" (the ability to stop a program,
 run some other program, then continue the first one).  */

/* #define NOMULTIPLEJOBS */

/* Define POSIX_SIGNAL if the system supports POSIX style
   signal handlers (sigaction, sigprocmask, sigpending, etc.).  */

#define POSIX_SIGNAL

/* Define USG_SIGNAL if signal handlers need to be reset when
   activated. */

/* #define USG_SIGNAL */

/* Define TRACE to enable tracing of various system calls.  */
/* #define TRACE */

#if defined(TRACE) && defined(emacs)
extern void trace (), init_trace ();

#define sigprocmask sys_sigprocmask
#define ioctl sys_ioctl
#endif

/* Emacs can read input using SIGIO and buffering characters itself,
   or using CBREAK mode and making C-g cause SIGINT.
   The choice is controlled by the variable interrupt_input.
   Define INTERRUPT_INPUT to make interrupt_input = 1 the default (use SIGIO)

   SIGIO can be used only on systems that implement it (4.2 and 4.3).
   CBREAK mode has two disadvatages
     1) At least in 4.2, it is impossible to handle the Meta key properly.
        I hear that in system V this problem does not exist.
     2) Control-G causes output to be discarded.
        I do not know whether this can be fixed in system V.

   Another method of doing input is planned but not implemented.
   It would have Emacs fork off a separate process
   to read the input and send it to the true Emacs process
   through a pipe.

   INTERRUPT_INPUT does not work too well under DG/UX when emacs
   is talking to a character terminal or rlogin session, as opposed
   to X windows.  X11term.c has been modified to request_sigio
   directly.
*/

/* #define INTERRUPT_INPUT */


/*
 *	Define HAVE_STRERROR if the library has the ANSI function
 *	strerror, otherwise use sys_errlist.
 */

#define HAVE_STRERROR

/*
 *	Define HAVE_TERMIO if the system provides sysV-style ioctls
 *	for terminal control.
 *	DG/UX has both BSD and AT&T style ioctl's.  Bsd ioctl's don't
 *	seem to wait for the output to drain properly, so use System V.
 */

#define HAVE_TERMIO

/*
 *	DG/UX 4.10 needs the following to turn on berkeley ioctl's.
 *	4.20 should fix this....
 */

/* #ifndef HAVE_TERMIO
   #define _BSD_TTY_FLAVOR 1
   #endif
*/

/*
 *	Use a Berkeley style sys/wait.h instead of POSIX.
 */

#define _BSD_WAIT_FLAVOR

/* Define a replacement for the baud rate switch, since DG/UX uses a different
   from BSD.  */

#define	BAUD_CONVERT    { 0, 110, 134, 150, 300, 600, 1200, 1800, 2400, \
			  4800, 9600, 19200, 38400 }

/*
 *	Define HAVE_TIMEVAL if the system supports the BSD style clock values.
 *	Look in <sys/time.h> for a timeval structure.
 */

#define HAVE_TIMEVAL

/*
 *	Define HAVE_GETTIMEOFDAY if gettimeofday() system call is available.
 */

#define HAVE_GETTIMEOFDAY

/*
 *	Define HAVE_SELECT if the system supports the `select' system call.
 */

#define HAVE_SELECT

/*
 *	Define HAVE_SOCKETS if the system supports sockets.
 */

#define HAVE_SOCKETS

/* Letter to use in finding device name of first pty,
  if system supports pty's.  'a' means it is /dev/ptya0  */

#define FIRST_PTY_LETTER 'p'

/*
 *	Define HAVE_PTYS if the system supports pty devices.
 *	The PTY_... overides the normal way of searching for pty's
 */

#define HAVE_PTYS

#define	PTY_ITERATION		for (i = 0; i <= 255; i++)
#define	PTY_NAME_SPRINTF	sprintf (ptyname, "/dev/ptyp%d", i);
#define	PTY_TTY_NAME_SPRINTF	sprintf (ptyname, "/dev/ttyp%d", i);

/*
 *	Define NONSYSTEM_DIR_LIBRARY to make Emacs emulate
 *      The 4.2 opendir, etc., library functions.
 */

/* #define NONSYSTEM_DIR_LIBRARY */

/*
 *	Define NLIST_STRUCT if the system has nlist.h
 */

#define	NLIST_STRUCT


/* Don't define AVERUN, since the traditional way of groping through
   /dev/kmem to get the load average doesn't work.  */

/* #define AVERUN */


/* Define this symbol if your system has the functions bcopy, etc. */

#define BSTRING


/* subprocesses should be defined if you want to
   have code for asynchronous subprocesses
   (as used in M-x compile and M-x shell).
   This is generally OS dependent, and not supported
   under most USG systems. */

#define subprocesses

/* If your system uses COFF (Common Object File Format) then define the
   preprocessor symbol "COFF". */

#ifdef m88k
#define COFF
#endif

/* define MAIL_USE_FLOCK if the mailer uses flock
   to interlock access to /usr/spool/mail/$USER.
   The alternative is that a lock file named
   /usr/spool/mail/$USER.lock.  */

/* #define MAIL_USE_FLOCK */

/* Define CLASH_DETECTION if you want lock files to be written
   so that Emacs can tell instantly when you try to modify
   a file that someone else has modified in his Emacs.  */

/* #define CLASH_DETECTION */

/* Here, on a separate page, add any special hacks needed
   to make Emacs work on this system.  For example,
   you might define certain system call names that don't
   exist on your system, or that do different things on
   your system and must be used only through an encapsulation
   (Which you should place, by convention, in sysdep.c).  */


/* On USG systems the system calls are interruptable by signals
 that the user program has elected to catch.  Thus the system call
 must be retried in these cases.  To handle this without massive
 changes in the source code, we remap the standard system call names
 to names for our own functions in sysdep.c that do the system call
 with retries. */

#define open  sys_open
#define close sys_close
#define read  sys_read
#define write sys_write

#define INTERRUPTABLE_OPEN
#define INTERRUPTABLE_CLOSE
#define INTERRUPTABLE_IO


/* Some compilers tend to put everything declared static
   into the initialized data area, which becomes pure after dumping Emacs.
   On these systems, you must #define static as nothing to foil this.
   Note that emacs carefully avoids static vars inside functions.  */

#ifndef __GNUC__
#define static
#endif

#if !defined(__STDC__) && defined(emacs)
/* Define library functions and/or system calls that are used.
   Until we supply prototypes, don't declare these functions
   when used with GCC without -traditional.  */

extern int bzero (), bcmp (), bcopy ();
extern int ioctl (), sleep (), select (), dup2 (), getpid ();
extern int setpgrp (), getpgrp (), gethostname ();
extern int open (), read (), write (), close (), fsync ();
extern int _flsbuf ();
extern int tputs (), tgetent (), tgetflag (), tgetnum ();
#endif


