/* defines for sheet support */

/* Source code copyright 1989 by Alan M. Carroll, all rights reserved.
 * This code may be freely distributed as long as the copyright is preserved.
 */

#ifndef XPNTR
#include "lisp.h"
#endif
struct Root_Block
    {
    int lisp_size;                      /* size of the structure */
    struct Lisp_Vector *lisp_next;	/* vector next */
    /* sheet support */
    Lisp_Object next,prev;		/* links for ring */
    Lisp_Object ewin;			/* root window of screen */
    Lisp_Object select;			/* last selected window */
    Lisp_Object seq;			/* sequence number */
    Lisp_Object styles;			/* character drawing styles */
    /* these next two are Raw Data, and have to be handled internally */
    Lisp_Object x11;                    /* sheet for x-window display */
    Lisp_Object win;                    /* display data */
    Lisp_Object update;			/* update when not current? */
    Lisp_Object motion_hints;		/* motion hints enabled? */
    Lisp_Object needs_update;		/* munged, needs updated */
    Lisp_Object needs_display;	        /* layout done, need to display */
    } ;

#define XROOT(a)        ( (struct Root_Block *) XPNTR(a) )
#define ROOTP(a)	( XTYPE((a)) == Lisp_Root_Block )

extern Lisp_Object Qepoch_screenp;
#define CHECK_SCREEN(x, i) \
  { if (XTYPE ((x)) != Lisp_Root_Block) x = wrong_type_argument (Qepoch_screenp, (x)); }

#define XA_EPOCH_CURRENT	"EPOCH_CURRENT"
#define XA_EPOCH_SCREEN_ID	"EPOCH_SCREEN_ID"
/* - - - - - - - - - - - - - - - - - - - - - */
/* useful macros */
#define EDIT_SCREEN (XWINDOW(XWINDOW(minibuf_window)->prev)->root)
/* fix up the window pointer in the root block */
#define RW_FIXUP(rb)    { register Lisp_Object pw;\
			      while ((pw=XWINDOW((rb)->ewin)->parent)\
				     != (rb)->ewin && !NULL(pw))\
			          (rb)->ewin = pw;\
			}

/* ------------------------------------------------------------------------ */
extern struct Root_Block *mini_root;
extern struct Root_Block *cur_root;
