/* Screen descriptors - data needed for Emacs to do display operations
 * Mostly things that used to be global Emacs vars.
 */

/* Source code copyright 1989 by Alan M. Carroll, all rights reserved.
 * This code may be freely distributed as long as the copyright is preserved.
 */

struct W_Screen
    {
    /* Emacs values that used to be globals */
    int width,height;           /* character size of the screen */
    int cursor_x,cursor_y;      /* where the cursor _should_ be */
    int flexlines;		/* pretend there are this many on screen */

    int size_change_pending;	/* got a size change request during update */
    int new_width,new_height;	/*  what to change to when we have a chance */

    /* screen descriptor arrays */
    struct display_line *phys_line[MScreenLength + 1];
    struct display_line *desired_line[MScreenLength + 1];
/*
    char updated[MScreenLength];
*/
    } ;

/* define access macros into the structures */
extern struct W_Screen *cur_Wscreen;
#define XWSCREEN(a)  ((struct W_Screen *)XPNTR(a))
#define WS	cur_Wscreen
#define WS_DEF	struct W_Screen *ws = XWSCREEN(rb->win)

#define dougW(b) (cur_Wscreen->b)

/* And these are the mappings */

#define SCREEN_HEIGHT   dougW(height)
#define SCREEN_WIDTH    dougW(width)
#define PhysScreen      dougW(phys_line)
#define DesiredScreen   dougW(desired_line)
#define cursX           dougW(cursor_x)
#define cursY           dougW(cursor_y)
#define FLEXLINES	dougW(flexlines)
