/* X-window control values - things that are needed to talk to X-server
 * correctly
 */

/* Source code copyright 1989 by Alan M. Carroll, all rights reserved.
 * This code may be freely distributed as long as the copyright is preserved.
 */

struct X_Screen
{
  Display *display;		/* X-window display - a physical hunk of
				   hardware driven by a server */
  Window xid;			/* window structure for X calls. Internally
				 * referred to as a "screen" because Emacs
				 * has it's own meaning for "window"
				 */
  int plane;			/* physical display surface - what X calls
				   a "screen" */
  int pixwidth,pixheight;	/* size of the sheet in pixels */
  int basex,basey;		/* upper left corner location */
  int out_border;		/* external border width */
  int in_border;		/* internal border width */
  unsigned long border_color;	/* color of the border */
  unsigned long background;	/* background color */
  unsigned long foreground;	/* foreground color */
  unsigned long cursor_color;	/* color of the cursor outline */
  XColor xfcursor,xbcursor;	/* X cursor colors */
  Colormap colormap;		/* X color map resource ID */
  char *font_name;		/* name of the current font */
  int font_width,font_height;	/* current font parms */
  int font_base;		/* base line height */
  int font_id;			/* X-window font number */
  GC gc_norm,gc_rev,gc_curs;	/* graph contexts for various ops */
  GC gc_style;			/* temp GC for the various styles */
  GC gc_inverse;		/* GC for background rectangle filling */
  int vis_x,vis_y;		/* where the cursor really is */
  Cursor the_cursor;		/* the cursor itself */
  int cursor_glyph;		/* cursor glyph (font index) */
  char mapped;			/* currently mapped onto display? */
  char cursor_outline;		/* should cursor be an outline? */
  char cursor_exists;		/* cursor currently plotted in screen? */
  char highlight;		/* highlighting flag */

  char configure_pending;	/* configure event pending */
  int new_height,new_width;	/* if pending, the new size */

} ;

/* - - */
extern struct X_Screen *cur_Xscreen;

#define XXSCREEN(a)  ((struct X_Screen *)XPNTR(a))
#define XS_DEF		struct X_Screen *xs = XXSCREEN(rb->x11)

#ifndef XXSELECT
#define XXSELECT(r)     (cur_root = (r), cur_Xscreen=(r)->x11,\
                         cur_Wscreen=(r)->win)
#endif

#define NORMAL_INPUT	( KeyPressMask | ExposureMask | ButtonPressMask | ButtonReleaseMask | FocusChangeMask | PropertyChangeMask | EnterWindowMask | LeaveWindowMask | StructureNotifyMask )

#ifdef ALL_MOTIONS
#define MOTION_INPUT ( PointerMotionMask | PointerMotionHintMask )
#else /* not ALL_MOTIONS */
#define MOTION_INPUT ( ButtonMotionMask | PointerMotionHintMask )
#endif /* not ALL_MOTIONS */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
