#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <X11/Xutil.h>

#define XMOUSEBUFSIZE 20

#ifndef sigmask
#define sigmask(no) (1L << ((no) - 1))
#endif

#define BLOCK_INPUT_DECLARE() int BLOCK_INPUT_mask

#ifdef SIGIO
#ifdef POSIX_SIGNAL
extern sigset_t zero_sigmask;
#undef BLOCK_INPUT_DECLARE
#define BLOCK_INPUT_DECLARE() sigset_t BLOCK_INPUT_mask, BLOCK_INPUT_new_mask
#define BLOCK_INPUT() \
  { \
    BLOCK_INPUT_new_mask = zero_sigmask; \
    sigaddset (&BLOCK_INPUT_new_mask, SIGIO); \
    sigprocmask (SIG_BLOCK, &BLOCK_INPUT_new_mask, &BLOCK_INPUT_mask); \
  }
#define UNBLOCK_INPUT() sigprocmask (SIG_SETMASK, &BLOCK_INPUT_mask, (sigset_t *)0)
#else /* not POSIX_SIGNAL */
#define BLOCK_INPUT() BLOCK_INPUT_mask = sigblock (sigmask (SIGIO))
#define UNBLOCK_INPUT() sigsetmask (BLOCK_INPUT_mask)
#endif /* not POSIX_SIGNAL */
#else /* not SIGIO */

#define BLOCK_INPUT()
#define UNBLOCK_INPUT()
#endif /* SIGIO */

#define HOLD_INPUT(a)    \
{ BLOCK_INPUT_DECLARE(); \
  BLOCK_INPUT();         \
  a;                     \
  UNBLOCK_INPUT();       \
}
#define CLASS  "emacs"	/* class id for GNU Emacs, used in .Xdefaults, etc. */





























