/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <xview/xview.h>

#include "browser.h"
#include "hb_config.h"

extern HBNODE *node_root;
extern HBLINK *link_root;
extern HBNODE *node_dir_ptr;




/*******************************************************************
** rm_node_list() --- free all the node struct list
*******************************************************************/

rm_node_list(node_ptr)
HBNODE *node_ptr;
{
  if (node_ptr->next == NULL)
    free(node_ptr);
  else
  {
    rm_node_list(node_ptr->next);
    free(node_ptr);
  }
}


/*******************************************************************
** delete_link()  --- remove a link form the link_struct
*******************************************************************/

delete_link(num)
int num;
{
  HBLINK *link_ptr;

  link_ptr = link_root;
  
  if (link_ptr->num == num)	/* is it the first element ? */
  {
    link_root = link_root->next;
    free(link_ptr);
  }
  else
  {
    for ( ; ((link_ptr->next != NULL) && (link_ptr->next->num != num));
	 link_ptr = link_ptr->next);

    if ((link_ptr->next != NULL) && (link_ptr->next->num == num))
    {
      HBLINK *tmp;
      
      tmp = link_ptr->next;

      link_ptr->next = link_ptr->next->next;
      free(tmp);
    }
  }
}


/*******************************************************************
** insert_new_link() --- insert new link in link list
*******************************************************************/

insert_new_link(num)
int num;
{
  HBLINK *link_ptr, *tmp;

  tmp = (HBLINK *) malloc(sizeof(HBLINK));
  link_ptr = link_root;

  link_root = tmp;

  tmp->num = num;
  tmp->next = link_ptr;
  tmp->att_frame = NULL;

  hb_multi_Read(tmp->num, LNAME);
  hb_multi_Read(tmp->num, TODATANODE_NO);
  
  send_network_buffer();	/* Send all the read calls NOW! */

  if(!hb_read_sok_int())	/* read the name */
  {
    char *value;
    int length;
	
    receivesok(&value, &length);
    strcpy(tmp->name, value);
    free(value);
  }
  
  if(!hb_read_sok_int())	/* read the to_node */
  {
    int *value;
    int length;
    
    receivesok(&value, &value);
    tmp->to_node = *value;
    free(value);
  }
}

  
/*******************************************************************
** insert_new_node() --- insert a new node in the node list
*******************************************************************/

insert_new_node(num)
int num;
{
  HBNODE *node_ptr, *tmp;
  
  tmp = (HBNODE *) malloc(sizeof(HBNODE));
  node_ptr = node_root;

  if (node_dir_ptr == node_root)
    node_dir_ptr = tmp;

  node_root = tmp;

  tmp->num = num;
  tmp->type = NODE;
  tmp->x_coor = 20;
  tmp->y_coor = 20;
  tmp->shown = TRUE;
  tmp->att_frame = NULL;
  tmp->link_num = NULL;
  strcpy(tmp->font, "No font");
  strcpy(tmp->geometry, "20x60"); 
  tmp->locked = FALSE;
  tmp->dir = NULL;

  tmp->next = node_ptr;
}

	
/*******************************************************************
** find_node() --- find a node. Return the node if found, else NULL
*******************************************************************/

HBNODE *find_node(num, node)
int num;
HBNODE *node;
{
  HBNODE *node_ret;
  
  if (node == NULL)
    return NULL;
  if(node->num == num)
    return node;
  if(node->dir != NULL)
  {
    if ((node_ret = find_node(num, node->dir)) != NULL)
      return(node_ret);
  }
  if(node->next != NULL)
  {
    if ((node_ret = find_node(num, node->next)) != NULL)
	return(node_ret);
  }
  return NULL;
}


/*******************************************************************
** find_pre_node() --- find a node. Return the node if found, else NULL
*******************************************************************/

HBNODE *find_pre_node(num, node)
int num;
HBNODE *node;
{
  HBNODE *node_ret;

  if (node == NULL)
    return NULL;
  if(node->num == num)		/* if find node is root-> */
    return node;
  if(node->dir != NULL)
  {
    if(node->dir->num == num)
      return node;
    if ((node_ret = find_pre_node(num, node->dir)) != NULL)
      return(node_ret);
  }
  if(node->next != NULL)
  {
    if(node->next->num == num)
      return node;
    if ((node_ret = find_pre_node(num, node->next)) != NULL)
      return(node_ret);
  }  
  return NULL;
}
  

/*******************************************************************
** find_name_node() --- find a node. Return the node if found, else NULL
*******************************************************************/

HBNODE *find_name_node(str, node)
char *str;
HBNODE *node;
{
  HBNODE *node_ret;
  
  if (node == NULL)
    return NULL;
  if(!strcmp(node->name, str))
    return node;
  if(node->dir != NULL)
  {
    if ((node_ret = find_name_node(str, node->dir)) != NULL)
      return(node_ret);
  }
  if(node->next != NULL)
  {
    if ((node_ret = find_name_node(str, node->next)) != NULL)
      return(node_ret);
  }
  return NULL;
}


/*******************************************************************
** find_dir_node() --- find a node in same directory
*******************************************************************/

HBNODE *find_dir_node(num, node)
int num;
HBNODE *node;
{
  HBNODE *node_tmp;
  
  for(node_tmp = node; ((node_tmp != NULL) && (node_tmp->num != num));
      node_tmp = node_tmp->next);

  if (node_tmp == NULL)
    return NULL;
  if (node_tmp->num == num)
    return node_tmp;
}


/*******************************************************************
** find_link() --- find a link by it's number
*******************************************************************/

HBLINK *find_link(num)
int num;
{
  HBLINK *link_tmp;
  
  for(link_tmp = link_root; (link_tmp != NULL) && (link_tmp->num != num);
      link_tmp = link_tmp->next);

  if (link_tmp == NULL)
    return NULL;
  if (link_tmp->num == num)
    return link_tmp;
}


/*******************************************************************
** delete_name_node()
*******************************************************************/

delete_name_node(str)
char *str;
{
  HBNODE *node_tmp;
  
  if ((node_tmp = find_name_node(str, node_root)) != NULL)
    delete_node(node_tmp->num);
}


/*******************************************************************
** move_node()
*******************************************************************/

move_node(nodenum, tonum)
int nodenum;
int tonum;
{
  HBNODE *pre_node;
  HBNODE *moving_node;
  HBNODE *to_node;
  HBNODE *help_node;

  pre_node = find_pre_node(nodenum, node_root);

  if ((pre_node == node_root) && (pre_node->num == nodenum))
  {
    if (node_dir_ptr == node_root)
      node_dir_ptr = node_root->next; /* bug if top level is empty */
    
    node_root = node_root->next;

    if (tonum == 0)		/* move to top level */
    {
      help_node = pre_node;
      pre_node = pre_node->next;
      to_node = node_root;
      if (node_dir_ptr == node_root)
	node_dir_ptr = help_node; /* bug if top level is empty */
      node_root = help_node;
      help_node->next = to_node;
    }
    else
    {
      to_node = find_node(tonum, node_root);
      
      help_node = to_node->dir;
      to_node->dir = pre_node;
      pre_node->next = help_node;
    }
  }
  else
  {
    if (pre_node != NULL)
    {
      if ((pre_node->dir != NULL) && (pre_node->dir->num == nodenum))
      {
	moving_node = pre_node->dir;
	pre_node->dir = pre_node->dir->next;
      }
      else
      {
	moving_node = pre_node->next;
	pre_node->next = pre_node->next->next;
      }
      
      if (tonum == 0)		/* move to top level */
      {
	to_node = node_root;
	if (node_dir_ptr == node_root)
	  node_dir_ptr = moving_node; /* bug if top level is empty */
	node_root = moving_node;
	moving_node->next = to_node;
      }
      else
      {
	to_node = find_node(tonum, node_root);
	
	help_node = to_node->dir;
	to_node->dir = moving_node;
	moving_node->next = help_node;
      }
    }
  }
}


/*******************************************************************
** delete_node()  --- remove a node form the node list
*******************************************************************/

delete_node(num)
int num;
{
  HBNODE *node_ptr, *node_tmp;

  if (node_root->num == num)
  {
    node_tmp = node_root;
    
    if (node_root->next != NULL)
    {
      if (node_dir_ptr == node_root)
	node_dir_ptr = node_root->next;
      
      node_root = node_root->next;
      free(node_tmp);
    }
    else if (node_root->dir != NULL)
    {
      if (node_dir_ptr == node_root)
	node_dir_ptr = node_root->dir;

      node_root = node_root->dir;
      free(node_tmp);
    }
    else
      node_root = NULL;
  }
  else
  {
    node_ptr = (HBNODE *)find_pre_node(num, node_root);

    if ((node_ptr->next != NULL) && (node_ptr->next->num == num))
    {
      node_tmp = node_ptr->next;
      node_ptr->next = node_ptr->next->next;
      free(node_tmp);
    }
    else if ((node_ptr->dir != NULL) && (node_ptr->dir->num == num))
    {
      node_tmp = node_ptr->dir;
      node_ptr->dir = node_ptr->dir->next;
      free(node_tmp);
    }      
  }
}


/*******************************************************************
** delete_link_from_node() --- delete a link from LINKNUM
*******************************************************************/

delete_link_from_node(fromnode, num)
int fromnode;
int num;
{
  HBNODE *node_ptr;
  HBLINKLIST *link_list, *link_tmp;
  
  node_ptr = (HBNODE *)find_node(fromnode, node_root);

  if (node_ptr != NULL)
  {
    link_list = node_ptr->link_num;
    
    if (link_list != NULL)
    {
      if (link_list->num != num)
      {
	for (;((link_list->next != NULL) && (link_list->next->num != num));
	     link_list = link_list->next);
	
	if ((link_list->next != NULL) && (link_list->next->num == num))
	{
	  link_tmp = link_list->next;
	  link_list->next = link_list->next->next;
	  free(link_tmp);
	}
      }
      else
      {
	link_tmp = node_ptr->link_num;
	node_ptr->link_num = node_ptr->link_num->next;
	free(link_tmp);
      }
    }
  }
}

  
/*******************************************************************
** test_lists()
*******************************************************************/

test_lists()
{
  HBNODE *node_ptr;
  HBLINK *link_ptr;
  struct link_list *list_ptr;
  
  /** all nodes **/

  printf("NODES\n===========\n");

  for(node_ptr = node_root; node_ptr != NULL; node_ptr = node_ptr->next)
  {
    printf("\nnum: %d, name: %s, link_num: ", node_ptr->num, node_ptr->name);
    
    for(list_ptr = node_ptr->link_num;
	list_ptr != NULL; list_ptr = list_ptr->next)
      printf("%d ", list_ptr->num);
  }

  printf("\n\n\nLINKS\n===========\n");
  
  for(link_ptr = link_root; link_ptr != NULL; link_ptr = link_ptr->next)
  {
    printf("num: %d, name: %s, to_node: %d\n", link_ptr->num, link_ptr->name, link_ptr->to_node);
  }
}


/*******************************************************************
** test_move()
*******************************************************************/

test_move(node)
HBNODE *node;
{
  for(; node != NULL; node = node->next)
  {
    fprintf(stderr,"%d, type: %d\n", node->num, node->type);

    if (node->type == DIR)
      test_move(node->dir);
  }
}

    
  
  
