/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/** include files **/

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/font.h>
#include <xview/textsw.h>

#include "browser.h"

/** extern definitions **/

extern Frame baseframe;
extern Panel basepanel;
extern Canvas canvas;


/*******************************************************************
** edit_node(node_ptr) --- call the editor and get data from HB
*******************************************************************/

edit_node(node_ptr)
HBNODE *node_ptr;
{
  Textsw textsw;
  char *value;
  int len;
  Frame textframe;
  int row, col;
  char buf[10];
  char *buf_ptr;
  
  if (!strcmp(node_ptr->font, "No font"))
    load_font_and_geo(node_ptr);

  strcpy(buf, node_ptr->geometry);
  
  col = atoi(buf);
  buf_ptr = (char *)strchr(buf, 'x');
  buf_ptr++;
  row = atoi(buf_ptr);

  textframe = (Frame)xv_create(baseframe, FRAME,
			       XV_LABEL, node_ptr->name,
			       XV_X, node_ptr->x_coor,
			       XV_Y, node_ptr->y_coor,
			       NULL);

  textsw = (Textsw)xv_create(textframe, TEXTSW,
			     WIN_ROWS, row,
			     WIN_COLUMNS, col,
			     TEXTSW_DISABLE_LOAD, TRUE,
			     TEXTSW_READ_ONLY, TRUE,
			     NULL);

  window_fit(textframe);
  
  hb_Read(node_ptr->num, 517, &value, &len); /* read the data field */

  textsw_insert(textsw, value, len); /* append data to the editor */
  xv_set(textframe, TEXTSW_MODIFIED, FALSE, NULL); /* it's not modified */

  xv_set(baseframe, FRAME_BUSY, TRUE, NULL);
  xv_set(textframe, XV_SHOW, TRUE, NULL);
  xv_set(baseframe, FRAME_BUSY, FALSE, NULL);
}


