/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/** Include Files **/

#include <stdio.h>
#include <xview/xview.h>
#include <xview/canvas.h>g
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#include <xview/panel.h>

#include "browser.h"
#include "hb_config.h"

/** Extern definitions **/
extern Canvas canvas;
extern Frame baseframe;
extern HBNODE *node_dir_ptr;
extern HBNODE *node_ptr;

extern int rename_proc();


/** Global variables **/

char hb_on_machine[50] = "";
HBNODE *node_root = NULL;
HBLINK *link_root = NULL;

int socketid = SOCKETID;	/* Global var. to define socketid */
char *user_full_name;

Frame rename_frame = NULL;	/* the frame for rename node */


/*******************************************************************
** load_layout_file() --- load the specified file
*******************************************************************/

void load_layout_file(file)
char *file;
{
  FILE *fp;
  char str[100];
    
  if ((fp = fopen(file, "r")) == NULL)
  {
    strcpy(str, "Can't open file: ");
    strcat(str, file);
    
    notice_prompt(canvas, NULL,
		       NOTICE_MESSAGE_STRINGS, str, NULL,
		       NOTICE_BUTTON_YES, "OK", NULL);
  }
  else
  {
    int x,y, num, parrent, type;

    fscanf(fp, "%d\t%d\n", &x, &y);
    xv_set(canvas, XV_HEIGHT, x, NULL);
    xv_set(canvas, XV_WIDTH, y, NULL);
    window_fit(baseframe);
    
    
    while(fscanf(fp, "%d\t%d\t%d\t%d\t%d\n",
		 &num, &parrent, &type, &x, &y) != EOF)
    {
      HBNODE *ptr;

      if (parrent != 0)
	move_node(num, parrent);
	
      ptr = (HBNODE *)find_node(num, node_root);
      if (ptr != NULL)
      {
	ptr->x_coor = x;
	ptr->y_coor = y;
	ptr->type = type;
      }
    }
    fclose(fp);

    redraw_all_paintwin();
  }
}


/*******************************************************************
** store_dir() --- saves the dir structure in file
*******************************************************************/

store_dir(fp, ptr, parrent)
FILE *fp;
HBNODE *ptr;
int parrent;
{
  for (; ptr != NULL; ptr = ptr->next)
  {
    fprintf(fp,"%d\t%d\t%d\t%d\t%d\n",
	    ptr->num, parrent, ptr->type, ptr->x_coor, ptr->y_coor);
    if (ptr->type == DIR)
      store_dir(fp, ptr->dir, ptr->num);
  }
}


  
/*******************************************************************
** save_layout_file() --- save the current layout in file
*******************************************************************/

save_layout_file(file)
char *file;
{
  FILE *fp;
  char str[100];

  if ((fp = fopen(file,"w")) == NULL)
  {
    strcpy(str, "Can't open file: ");
    strcat(str, file);
    
    notice_prompt(canvas, NULL,
		       NOTICE_MESSAGE_STRINGS, str, NULL,
		       NOTICE_BUTTON_YES, "OK", NULL);
  }
  else
  {
    HBNODE *ptr;

    strcpy(str, "Saving layout in file `");
    strcat(str, file);
    strcat(str, "' ...");
    
    print_left_footer(str);
    
    fprintf(fp,"%d\t%d\n", xv_get(canvas,XV_HEIGHT,NULL),
	    xv_get(canvas,XV_WIDTH,NULL)); /* save frame size */
    store_dir(fp, node_root, 0);
    fclose(fp);

    strcat(str, " done!");
    print_left_footer(str);
    sleep(1);
    print_left_footer("");
  }
}


/*******************************************************************
** connect_to_hb() --- connecting to the HyperBase
*******************************************************************/

connect_to_hb()
{
  char str[100];
  int *vals;
  HBNODE *tmp;
  HBNODE *insert_ptr;
  HBLINK *link_tmp;
  HBLINK *link_insert_ptr;
  int x, y;
  
  if ((user_full_name = (char *)getenv("NAME")) == NULL)
    if ((user_full_name = (char *)getenv("USER")) == NULL)
      *user_full_name = '?';
  
  strcpy(str, "Connecting to `");
  strcat(str, hb_on_machine);
  strcat(str, "' with user ID `");
  strcat(str, user_full_name);
  strcat(str,"' ...");
  print_left_footer(str);

  if (hb_Connect(hb_on_machine, user_full_name) != 0)
  {
    strcpy(str, "Can't connect to ");
    strcat(str, hb_on_machine);
    print_left_footer(str);
    sleep(2);
    print_left_footer("");
  }
  else
  {

    /** Get all the nodes **/
    hb_Browse(DATANODE, &vals);	
    for(x=20, y=20; *vals != 0; vals++, y+=50)
    {
      tmp = (HBNODE *) malloc(sizeof(HBNODE));
      if (node_root == NULL)	/* no nodes in the node_struct list */
      {
	node_root = tmp;	/* set the root */
	node_dir_ptr = tmp;	/* set the default dir to the top */
      }
      else
      {				/* append */
	insert_ptr = node_root;
	while(insert_ptr->next != NULL) /* find end */
	  insert_ptr = insert_ptr->next;
      insert_ptr->next = tmp;	/* append new node struct */
      }
      
      tmp->num = *vals;
      tmp->type = NODE;
      tmp->x_coor = x;
      tmp->y_coor = y;
      tmp->shown = TRUE;
      tmp->att_frame = NULL;
      tmp->link_num = NULL;
      strcpy(tmp->font, "No font");
      strcpy(tmp->geometry, "20x60"); 
      tmp->locked = FALSE;
      tmp->next = NULL;
      tmp->dir = NULL;
      
      if ((y+40) > 400)
      {
	y = 20;
	x += 70;
      }
    }
    
    /** Get all the links **/
    hb_Browse(LINKNODE, &vals);	
    for(; *vals != 0; vals++)
    {
      link_tmp = (HBLINK *) malloc(sizeof(HBLINK));
      if (link_root == NULL)	/* no nodes in the node_struct list */
	link_root = link_tmp;		/* set the root */
      else
      {				/* append */
	link_insert_ptr = link_root;
	while(link_insert_ptr->next != NULL) /* find end */
	  link_insert_ptr = link_insert_ptr->next;
	link_insert_ptr->next = link_tmp;	/* append new node struct */
      }
      
      link_tmp->num = *vals;
      link_tmp->att_frame = NULL;
      link_tmp->next = NULL;
    }
    
    /** Read node information **/
    tmp = node_root;
    for(; tmp != NULL; tmp = tmp->next)
    {
      hb_multi_Read(tmp->num, NNAME);
      hb_multi_Read(tmp->num, LINKNUM);
    }
    
    /** Read link information **/
    link_tmp = link_root;
    for(; link_tmp != NULL; link_tmp = link_tmp->next)
    {
      hb_multi_Read(link_tmp->num, LNAME);
      hb_multi_Read(link_tmp->num, TODATANODE_NO);
    }
    
    /** Send all the read calls NOW! **/
    send_network_buffer();
    
    /** Setup all the nodes **/
    tmp = node_root;
    for(; tmp != NULL; tmp = tmp->next)
    {
      if(!hb_read_sok_int())
      {
	char *value;
	int length;
	int *linknums;
	struct link_list *link_ptr, *link_list_root;
	
	receivesok(&value, &length);
	strcpy(tmp->name, value);
	free(value);
	
	if(!hb_read_sok_int())
	{
	  int *free_ptr;
	  
	  receivesok(&linknums, &length);
	  free_ptr = linknums;
	  for(; length > 0; length -= 4)
	  {
	    struct link_list *ptr;
	    
	    link_ptr = (struct link_list *)malloc(sizeof(struct link_list));
	    if (tmp->link_num == NULL)
	      link_list_root = tmp->link_num = link_ptr;
	    else
	    {
	      ptr = link_list_root;
	      while (ptr->next != NULL)
		ptr = ptr->next;
	      ptr->next = link_ptr;
	    }
	    link_ptr->num = *linknums;
	    link_ptr->next = NULL;
	    linknums++;
	  }
	  free(free_ptr); 
	}
      }
    }
    
    /** Setup all links **/
    link_tmp = link_root;
    for(; link_tmp != NULL; link_tmp = link_tmp->next)
    {
      if(!hb_read_sok_int())	/* read the name */
      {
	char *value;
	int length;
	
	receivesok(&value, &length);
	strcpy(link_tmp->name, value);
	free(value);
      }
      
      if(!hb_read_sok_int())	/* read the to_node */
      {
	int *value;
	int length;

	receivesok(&value, &value);
	link_tmp->to_node = *value;
	free(value);
      }
    }

    /* test_lists(); */

    redraw_all_paintwin();
      
    setup_events();		/* make all the event stuff ready */

    {
      char default_file[256];
      
      strcpy(default_file, getenv("HOME"));
      strcat(default_file, "/.ehts-browser");
      
      load_layout_file(default_file);
    }
    
    print_left_footer("");	/* clear the footers */
    print_right_footer("");
  }
}



/*******************************************************************
** disconnect_to_hb() --- disconnecting from the HyperBase
*******************************************************************/

disconnect_to_hb()
{
  print_left_footer("Disconnecting from HyperBase ...");
  hb_Disconnect(); 
  if (node_root != NULL)
  {
    rm_node_list(node_root);
    free(node_root);
    node_root = NULL;
  }
  sleep(1);

  redraw_all_paintwin();
  
  print_left_footer("");
  print_right_footer("");
}




/*******************************************************************
** read_link_attributes --- read link att. and make a CMD_FRAME
*******************************************************************/

int read_link_attributes(link_ptr)
HBLINK *link_ptr;
{
  char *value;
  char linknum[5];
  int len;
  Panel link_att_panel;
  Panel_item link_name_item, link_num_item, last_mod_date_item,
             last_mod_by_item, crea_by_item, crea_date_item, to_node_item;
  HBNODE *node_ptr;
  
  hb_multi_Read(link_ptr->num, LLASTMODIFIEDDATE);
  hb_multi_Read(link_ptr->num, LLASTMODIFIEDBY);
  hb_multi_Read(link_ptr->num, LCREATEDDATE);
  hb_multi_Read(link_ptr->num, LCREATEDBYT5);

  send_network_buffer();

  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(link_ptr->last_modified_date, value);
    free(value);
  }  
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(link_ptr->last_modified_by, value);
    free(value);
  }  
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(link_ptr->created_date, value);
    free(value);
  }  
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(link_ptr->created_by, value);
    free(value);
  }

  
  node_ptr = (HBNODE *)find_node(link_ptr->to_node, node_root);
  
  link_ptr->att_frame = (Frame)xv_create(baseframe, FRAME_CMD,
					 XV_X, node_ptr->x_coor,
					 XV_Y, node_ptr->y_coor,
					 XV_WIDTH, 10,
					 XV_HEIGHT, 10,
					 FRAME_LABEL, "Link Attributes",
					 PANEL_LAYOUT, PANEL_HORIZONTAL,
					 NULL);
  link_att_panel = (Panel)xv_create(link_ptr->att_frame, PANEL, NULL);
  link_name_item = xv_create(link_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 5,
			     PANEL_LABEL_STRING, "Link name:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 29,
			     PANEL_VALUE, link_ptr->name,
			     NULL);
  sprintf(linknum, "%d", link_ptr->num);
  link_num_item = xv_create(link_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 22,
			     PANEL_LABEL_STRING, "Link number:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 3,
			     PANEL_VALUE, linknum,
			     NULL); 
  crea_by_item = xv_create(link_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 44,
			     PANEL_LABEL_STRING, "Created by:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 24,
			     PANEL_VALUE, link_ptr->created_by,
			     NULL);
  crea_date_item = xv_create(link_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 61,
			     PANEL_LABEL_STRING, "Created date:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 22,
			     PANEL_VALUE, link_ptr->created_date,
			     NULL);
  last_mod_by_item = xv_create(link_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 83,
			     PANEL_LABEL_STRING, "Last modified by:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 24,
			     PANEL_VALUE, link_ptr->last_modified_by,
			     NULL);
  last_mod_date_item = xv_create(link_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 100,
			     PANEL_LABEL_STRING, "Last modified date:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 22,
			     PANEL_VALUE, link_ptr->last_modified_date,
			     NULL);
  to_node_item = xv_create(link_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 125,
			     PANEL_LABEL_STRING, "To node:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 32,
			     PANEL_VALUE, node_ptr->name,
			     NULL);

  window_fit(link_att_panel);
  window_fit(link_ptr->att_frame);
  
}

    

/*******************************************************************
** read_node_attributes --- read node att. and make a CMD_FRAME
*******************************************************************/

int read_node_attributes(node_ptr)
HBNODE *node_ptr;
{
  char *value;
  char nodenum[5];
  int len;
  Panel node_att_panel;
  Panel_item node_name_item, node_num_item, last_mod_date_item,
             last_mod_by_item, crea_by_item, crea_date_item,
             font_item, geometry_item;
  
  hb_multi_Read(node_ptr->num, NLASTMODIFIEDDATE);
  hb_multi_Read(node_ptr->num, NLASTMODIFIEDBY);
  hb_multi_Read(node_ptr->num, NCREATEDDATE);
  hb_multi_Read(node_ptr->num, NCREATEDBYT5);
  hb_multi_Read(node_ptr->num, FONT);
  hb_multi_Read(node_ptr->num, GEOMETRY);

  send_network_buffer();

  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->last_modified_date, value);
    free(value);
  }  
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->last_modified_by, value);
    free(value);
  }  
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->created_date, value);
    free(value);
  }  
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->created_by, value);
    free(value);
  }
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->font, value);
    free(value);
  }
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->geometry, value);
    free(value);
  }

  node_ptr->att_frame = (Frame)xv_create(baseframe, FRAME_CMD,
					 XV_X, node_ptr->x_coor,
					 XV_Y, node_ptr->y_coor,
					 XV_WIDTH, 10,
					 XV_HEIGHT, 10,
					 FRAME_LABEL, "Node Attributes",
					 PANEL_LAYOUT, PANEL_HORIZONTAL,
					 NULL);
  node_att_panel = (Panel)xv_create(node_ptr->att_frame, PANEL, NULL);
  node_name_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 5,
			     PANEL_LABEL_STRING, "Node name:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 29,
			     PANEL_VALUE, node_ptr->name,
			     NULL);
  sprintf(nodenum, "%d", node_ptr->num);
  node_num_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 22,
			     PANEL_LABEL_STRING, "Node number:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 3,
			     PANEL_VALUE, nodenum,
			     NULL); 
  crea_by_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 44,
			     PANEL_LABEL_STRING, "Created by:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 24,
			     PANEL_VALUE, node_ptr->created_by,
			     NULL);
  crea_date_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 61,
			     PANEL_LABEL_STRING, "Created date:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 22,
			     PANEL_VALUE, node_ptr->created_date,
			     NULL);
  last_mod_by_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 83,
			     PANEL_LABEL_STRING, "Last modified by:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 24,
			     PANEL_VALUE, node_ptr->last_modified_by,
			     NULL);
  last_mod_date_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 100,
			     PANEL_LABEL_STRING, "Last modified date:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 22,
			     PANEL_VALUE, node_ptr->last_modified_date,
			     NULL);
  font_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 122,
			     PANEL_LABEL_STRING, "Font:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 5,
			     PANEL_VALUE, node_ptr->font,
			     NULL);
  geometry_item = xv_create(node_att_panel, PANEL_TEXT,
			     XV_X, 5,
			     XV_Y, 139,
			     PANEL_LABEL_STRING, "Geometry:",
			     PANEL_READ_ONLY, TRUE,
			     PANEL_VALUE_DISPLAY_LENGTH, 7,
			     PANEL_VALUE, node_ptr->geometry,
			     NULL);

  window_fit(node_att_panel);
  window_fit(node_ptr->att_frame);
  
}

    
/*******************************************************************
** rename_node()
*******************************************************************/

rename_node()
{
  Panel rename_panel;
  Panel_item rename_item;
  
  rename_frame = (Frame)xv_create(baseframe, FRAME_CMD,
					 XV_X, node_ptr->x_coor,
					 XV_Y, node_ptr->y_coor,
					 XV_WIDTH, 10,
					 XV_HEIGHT, 10,
					 FRAME_LABEL, "Rename node",
					 PANEL_LAYOUT, PANEL_HORIZONTAL,
					 NULL);
  rename_panel = (Panel)xv_create(rename_frame, PANEL, NULL);
  rename_item = xv_create(rename_panel, PANEL_TEXT,
			  XV_X, 5,
			  XV_Y, 5,
			  PANEL_LABEL_STRING, "Node name:",
			  PANEL_VALUE_DISPLAY_LENGTH, 50,
			  PANEL_NOTIFY_PROC, rename_proc,
			  PANEL_VALUE, node_ptr->name,
			  NULL);

  window_fit(rename_panel);
  window_fit(rename_frame);
}


/*******************************************************************
** load_font_and_geo() --- get font and geo from HyperBase
*******************************************************************/

load_font_and_geo(node_ptr)
HBNODE *node_ptr;
{
  char *value;
  int len;  

  hb_multi_Read(node_ptr->num, FONT);
  hb_multi_Read(node_ptr->num, GEOMETRY);

  send_network_buffer();

  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->font, value);
    free(value);
  }
  if (!hb_read_sok_int())
  {
    receivesok(&value, &len);
    strcpy(node_ptr->geometry, value);
    free(value);
  }
}


