;;!emacs
;;
;; FILE:         hsite.el
;; SUMMARY:      Site-specific setup for Hyperbole
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;;
;; ORIG-DATE:    15-Apr-91 at 00:48:49
;; LAST-MOD:     14-Dec-91 at 02:15:34 by Bob Weiner
;;
;; This file is part of Hyperbole.
;; 
;; Copyright (C) 1991, Brown University, Providence, RI
;; Developed with support from Motorola Inc.
;; 
;; Permission to use, modify and redistribute this software and its
;; documentation for any purpose other than its incorporation into a
;; commercial product is hereby granted without fee.  A distribution fee
;; may be charged with any redistribution.  Any distribution requires
;; that the above copyright notice appear in all copies, that both that
;; copyright notice and this permission notice appear in supporting
;; documentation, and that neither the name of Brown University nor the
;; author's name be used in advertising or publicity pertaining to
;; distribution of the software without specific, written prior permission.
;; 
;; Brown University makes no representations about the suitability of this
;; software for any purpose.  It is provided "as is" without express or
;; implied warranty.
;;
;;
;; DESCRIPTION:  
;;
;;   COPY THIS FILE TO hsite.el AND THEN MODIFY AS DESIRED.
;;   A line of the form:
;;
;;      (load "<HYP-DIR>/hsite")
;;
;;   in your .emacs file will then initialize Hyperbole whenever you
;;   start up.  Substitute your chosen path for <HYP-DIR>.
;;
;; DESCRIP-END.

;; ************************************************************************
;; Suggestions of what to include here.
;; Comment out and uncomment lines as desired.
;; ************************************************************************

(message "Initializing Hyperbole...")

;;; Choose a key on which to place the Hyperbole menus.
;;; For most people this key binding will work and will be equivalent
;;; to {C-h h}.
;;;
(define-key help-map "h" 'hui:menu)

;;; Uncomment or select a key if you want a site standard way of
;;; performing explicit button renames without invoking the Hyperbole
;;; menu.
;; (global-set-key "\C-cr" 'hui:ebut-rename)

;;; Uncomment this and choose a key binding if you want a site standard
;;; way to easily switch between the Smart Key mouse bindings and a set
;;; of personal mouse bindings.  You may instead show users how to bind
;;; this to a key via 'hyperb:init-hook' (see Hyperbole Manual).
;;;
;; (global-set-key "<KEY-BINDING>" 'sm-mouse-toggle-bindings)

;;; A value of t below will cause the the Smart Key to be bound to {C-u
;;; M-RTN} and the secondary Smart Key to {M-RTN}, in addition to any
;;; mouse key bindings.  Comment it out or set it to nil if you don't
;;; want these bindings.
;;;
(setq smart-key-init t)


;;; Substitute the directory in which you stored the Hyperbole code
;;; for <HYP-DIR> below.
;;;
(if (boundp 'hyperb:dir)
    nil
  (defconst hyperb:dir (file-name-as-directory "<HYP-DIR>")
    "Directory where Hyperbole code and doc files are kept."))
(let (newpath)
  (or (featurep 'set) (load (concat hyperb:dir "set")))
  (if (setq newpath (set:add hyperb:dir load-path))
      (setq load-path newpath)))

;;; Support button highlighting and flashing under Epoch.
;;;
(defvar hyperb:epoch-p
  (if (boundp 'epoch::version)
      (if (string< epoch::version "Epoch 4") "V3" "V4"))
  "Simplified Epoch version string, e.g. \"V4\", else nil.")

(if hyperb:epoch-p
    (progn
      (cond ((string< hyperb:epoch-p "V4") (require 'hui-epV3-b))
	    (t (require 'hui-epV4-b)))
      (fset 'hui:but-flash 'ep:but-flash)
      ;; This color cycling really must be done until a desired color is hit.
      ;; See the hui-epV* files for how this works.
      (ep:cycle-but-color)
      ;; If you use Epoch and find that the Hyperbole button flash time is
      ;; too slow or too fast, adjust it here.
      (defvar ep:but-flash-time 1000
	"Machine specific val for empty loop counter, Epoch but flash delay.")
      )
  (defun hui:but-flash ())
  )

;;; You may want to look at this file just to see what it does.
;;; It initializes the whole Hyperbole system.
;;;
(require 'hinit)

;;; Enables Smart Key mouse setup.
(sm-mouse-setup)

;;; Permits restore of screen configuration after any help buffer is shown
;;; by pressing either Smart Key at the end of the help buffer.  (Help buffer
;;; names end with "Help*".
;;;
(setq temp-buffer-show-hook 'smart-key-help-show)

;;; This may be removed if Hyperbole variables are never used in file local
;;; variable lists or if it causes a conflict with any local variable lists you
;;; use.  See the source file for more details.
;;;
(require 'hlvar)

;;; Support for encapsulations of any of these external systems may be
;;; enabled here.  You should be familiar with the external system before
;;; you try to use the Hyperbole support for it.
;;;
;(require 'hsys-hbase)
;(require 'hsys-wais)
;(require 'hsys-www)

(provide 'hsite)

(message "Hyperbole is ready for action.")
