;;!emacs
;;
;; FILE:         hui-epV4-b.el
;; SUMMARY:      Support color and flashing of hyper-buttons under Epoch V4
;; USAGE:        Epoch Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;;
;; ORIG-DATE:    27-Apr-91 at 05:37:10
;; LAST-MOD:     13-Dec-91 at 14:59:36 by Bob Weiner
;;
;; This file is part of Hyperbole.
;; It is for use with Epoch, a modified version of GNU Emacs.
;;
;; Copyright (C) 1991, Brown University, Providence, RI
;; Developed with support from Motorola Inc.
;; 
;; Permission to use, modify and redistribute this software and its
;; documentation for any purpose other than its incorporation into a
;; commercial product is hereby granted without fee.  A distribution fee
;; may be charged with any redistribution.  Any distribution requires
;; that the above copyright notice appear in all copies, that both that
;; copyright notice and this permission notice appear in supporting
;; documentation, and that neither the name of Brown University nor the
;; author's name be used in advertising or publicity pertaining to
;; distribution of the software without specific, written prior permission.
;; 
;; Brown University makes no representations about the suitability of this
;; software for any purpose.  It is provided "as is" without express or
;; implied warranty.
;;
;;
;; DESCRIPTION:  
;;
;;   Requires Epoch 4.0a or greater.
;;
;;   This is truly prototype code.
;;
;; DESCRIP-END.


(require 'hui-ep-but)

;;; ************************************************************************
;;; Public functions
;;; ************************************************************************

(defun ep:cycle-but-color (&optional color)
  (interactive)
  (if (<= (epoch::number-of-colors) 2)
      nil
    (if color (setq ep:color-ptr nil))
    (epoch::set-style-foreground
     ep:but (or color (car (ep:list-cycle ep:color-ptr ep:good-colors))))
    (epoch::set-style-background ep:flash-style (ep:but-color))
    (redraw-display)
    t))

(defun ep:but-flash ()
  "Flash a Hyperbole button at point to indicate selection, when using Epoch."
  (interactive)
  (let ((ibut) (prev)
	(start (hattr:get 'hbut:current 'lbl-start))
	(end   (hattr:get 'hbut:current 'lbl-end)))
    (and start end (setq prev (epoch::button-at (point))
			 ibut t)
	 (if (not prev) (ep:but-add start end ep:but)))
    (let* ((b (epoch::button-at (point)))
	   (a (and (epoch::buttonp b) (epoch::button-style b))))
      (if a
	  (progn
	    (epoch::set-button-style b ep:flash-style)
	    (epoch::redisplay-screen)
	    ;; Delay before redraw button
	    (let ((i 0)) (while (< i ep:but-flash-time) (setq i (1+ i))))
	    (epoch::set-button-style b a)
	    (epoch::redisplay-screen)
	    )))
    (if (and ibut (not prev)) (ep:but-delete))
    ))


;;; ************************************************************************
;;; Private variables
;;; ************************************************************************

(defvar ep:but (epoch::make-style) "Style for hyper-buttons.")
(defvar ep:flash-style (epoch::make-style) "Style for flashing hyper-buttons.")
(epoch::set-style-foreground ep:but (ep:but-color))
(epoch::set-style-background ep:but (epoch::background))
(epoch::set-style-background ep:flash-style (ep:but-color))
(epoch::set-style-foreground ep:flash-style (epoch::foreground))

(provide 'hui-epV4-b)
