;;!emacs
;;
;; FILE:         hui-mouse.el
;; SUMMARY:      Use key or mouse key for Hyperbole menus and arguments.
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;;
;; ORIG-DATE:    04-Feb-90
;; LAST-MOD:     13-Dec-91 at 15:01:40 by Bob Weiner
;;
;; This file is part of Hyperbole.
;;
;; Copyright (C) 1990, 1991, Brown University, Providence, RI
;; Available for use and distribution under the same terms as GNU Emacs.
;;
;;  This code is machine independent.  It works best with a pointing device but
;;  may also be used from a keyboard.  When used with a pointing device it
;;  requires an Emacs command that sets point to the location of the pointing
;;  device's cursor.
;;
;;  If you want to use your middle mouse button to select Hyperbole menu
;;  items, follow these instructions.
;;
;;  If you plan to use a mouse only with X windows, SunView, Apollo's DM,
;;  or under Epoch (X-Windowed version of Emacs from U of Illinois)
;;  and you want to use the middle and right buttons, you need not do
;;  any mouse configuration.  Your Emacs executable must have been built so
;;  as to include the mouse support files for your window system, however.
;;  These are in the Emacs "src" directory: for X "x*.c", for SunView
;;  "sunfns.c", and for Apollo DM "apollo.c" and "apollo.el".
;;
;;  To use a different mouse key or a different window system, modify the
;;  'sm-mouse-setup' in "hmouse-key.el".
;;
;;  If smart-key-init is non-nil when this package is loaded,
;;  {M-RTN} will run 'smart-key-meta'.  With an argument, it will run
;;  'smart-key'.  In most special read-only modes with their own keymaps, one
;;  can use {RTN} to run 'smart-key' and {M-RTN} to run 'smart-key-meta'.
;;
;; DESCRIP-END.

;; ************************************************************************
;; Public variables
;; ************************************************************************

(defvar mouse-set-point-command nil
  "*Command that sets point to mouse cursor position.")

(defconst smart-key-other-mode-cmd 'hui:menu
  "*Symbol name of command run by the Smart Key in an unspecified context.")

(defconst smart-key-meta-other-mode-cmd 'smart-key-summarize
  "*Symbol name of command run by the secondary Smart Key in an unspecified context.")

;; ************************************************************************
;; smart-key driver functions
;; ************************************************************************

(require 'hargs)
(require 'hmouse-key)
(require 'hmouse-drv)
(require 'hmous-info)

;; ************************************************************************
;; smart-key dispatch table
;; ************************************************************************

(defvar smart-key-value nil
  "Communicates a value between a Smart Key predicate and its actions.")

(defun smart-completion-help ()
  "Offer completion help for current minibuffer argument, if any."
  (and (where-is-internal 'minibuffer-completion-help (current-local-map))
       (minibuffer-completion-help)))

(defconst smart-key-alist
  '(
    ;;
    ;; If click in the minibuffer and reading an argument,
    ;; accept argument or give completion help.
    ((and (> (minibuffer-depth) 0)
	  (eq (selected-window) (minibuffer-window))
	  (not (eq hargs:reading-p 'hmenu))) .
     ((exit-minibuffer) . (smart-completion-help)))
    ;;
    ;; If reading a Hyperbole menu item or a Hyperbole or completion-based
    ;; argument, allow selection of an item at point.
    ((and (> (minibuffer-depth) 0) (setq smart-key-value (hargs:at-p))) .
     ((hargs:select-p smart-key-value) .
      (hargs:select-p smart-key-value 'meta)))
    ;;
    ((and (eolp) (not (eobp))) .
     ((scroll-up-eol) . (scroll-down-eol)))
    ;;
    ;; If on a Hyperbole button, perform action or give help.
    ((and (fboundp 'hbut:at-p) (or (hbut:at-p) (hbut:label-p))) .
     ((hui:hbut-act 'hbut:current) . (hui:hbut-help 'hbut:current)))
    ;;
    ;; Support direct selection and viewing on basic relational databases.
    ;; ((eq major-mode 'rdb-mode) . ((smart-rdb) . (smart-rdb-meta)))
    ;;
    ;; Restore screen and hide help buffer when click at buffer end
    ((and (= (point) (point-max)) (string-match "Help\\*$" (buffer-name))) .
     ((smart-key-help-hide) . (smart-key-help-hide)))
    ;;
    ((eq major-mode 'occur-mode) .
     ((occur-mode-goto-occurrence) . (occur-mode-goto-occurrence)))
    ;;
    ((eq major-mode 'moccur-mode) .
     ((moccur-mode-goto-occurrence) . (moccur-mode-goto-occurrence)))
    ;;
    ((eq major-mode 'Info-mode) .
     ((smart-info) .  (smart-info-meta)))
    )
  "Alist of predicates and form-conses.
When the smart-key or the smart-key-meta is pressed, the first or
second form, respectively, associated with the first non-nil predicate is
evaluated."
  )

(provide 'hui-mouse)
