;;!emacs
;;
;; FILE:         h-skip-bytec.lsp
;; SUMMARY:      Functions that should not be byte-compiled.
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Motorola, Inc., PWDG
;;
;; ORIG-DATE:     8-Oct-92 at 17:17:10
;; LAST-MOD:     11-Nov-92 at 16:07:35 by Bob Weiner
;;
;; This file is part of Hyperbole.
;; 
;; Copyright (C) 1992, Brown University, Providence, RI
;; Developed with support from Motorola Inc.
;; 
;; Permission to use, modify and redistribute this software and its
;; documentation for any purpose other than its incorporation into a
;; commercial product is hereby granted without fee.  A distribution fee
;; may be charged with any redistribution.  Any distribution requires
;; that the above copyright notice appear in all copies, that both that
;; copyright notice and this permission notice appear in supporting
;; documentation, and that neither the name of Brown University nor the
;; author's name be used in advertising or publicity pertaining to
;; distribution of the software without specific, written prior permission.
;; 
;; Brown University makes no representations about the suitability of this
;; software for any purpose.  It is provided "as is" without express or
;; implied warranty.
;;
;;
;; DESCRIPTION:  
;;
;;   DON'T byte-compile this file or its functions may not work.
;;   If we knew why they won't work, they wouldn't be in here.
;;
;; DESCRIP-END.

;;; ************************************************************************
;;; Public functions
;;; ************************************************************************

;;; For some reason, using this in byte-compiled form causes first character
;;; after mouse key depress to be dropped from input queue when running
;;; Emacs under X.  The non-byte-compiled form works fine.

(defun smart-key-mouse-set-point (args)
  "Sets point to Smart Key press/release location given by ARGS.
Returns arg list including x and y screen coordinates in chars and lines."
  (and (car args) (listp (car args)) (setq args (car args)))
  (let ((point-set-val (smart-key-set-point args)))
    (cond (hyperb:lemacs-p
	    ;; Modeline clicks return nil for X and Y event positions.
	    (if (event-x current-mouse-event)
		(copy-event current-mouse-event)
	      (read-mouse-position (selected-screen))))
	  (hyperb:epoch-p
	    ;; Modeline clicks return nil for point position so we
	    ;; must compute it instead of using the arguments given.
	    (let ((x-char (/ (* mouse::x (window-width))
			     (window-pixwidth)))
		  (y-char (/ (* mouse::y (window-height))
			     (window-pixheight))))
	      (apply 'list x-char y-char args)))
	  ((equal hyperb:window-system "apollo") point-set-val)
	  (t args))))

;;; ************************************************************************
;;; Private functions
;;; ************************************************************************

;;; ************************************************************************
;;; Private variables
;;; ************************************************************************

(provide 'h-skip-bytec)
