/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <stream.h>
#include <stdio.h>
#include "file.hh"

FILE* file::open(const char* filename)
{
  FILE* fd;
  
  if ((fd = fopen(filename,"r+")) == NULL)
    if ((fd = fopen(filename,"w+")) == NULL)
    {
      cerr << "Can't open or create file : " << filename << "\n";
      exit(-1);
    }
  return fd;
};

int file::close(FILE* stream)
{
  int a;

  if ((a = fflush(stream)) == EOF)
  {
    cerr << "Can't write buffer to file\n";
    exit(-1);
  }
  else if (fclose(stream) == EOF)
  {
    cerr << "Can't close file\n";
    exit(-1);
  }
  else
    return a;
};

long file::getpos(FILE* stream)
{
  long a;

  if ((a = ftell(stream)) == -1L)
  {
    cerr << "Can't get file position from file\n";
    exit(-1);
  }
  else
    return a;
};

int file::setpos(FILE* stream, long pos)
{
  int a;

  if ((a = fseek(stream,pos,0)) != NULL)
  {
    cerr << "Can't set file position in file\n";
    exit(-1);
  }
  else
    return a;
};

int file::reset(FILE* stream)
{
  int a;

  if ((a = fseek(stream,0L,0)) != NULL)
  {
    cerr << "Can't reset file\n";
    exit(-1);
  }
  else
    return a;
};

int file::readent(FILE* stream, int size, fileent* e)
{
  if ( (fread(*e,size,1,stream) != 1) || (feof(stream) != NULL) )
  {
    cerr << "Can't read entity from file\n";
    exit(-1);
  }
  else
    return 0;
};

int file::writeent(FILE* stream, int size, fileent e)
{
  if ( (fwrite(e,size,1,stream) != 1) || (ferror(stream) != NULL) )
  {
    cerr << "Can't write entity to file\n";
    exit(-1);
  }
  else
    return 0;
};

int file::readlong(FILE* stream, long** addr)
{
  if ( (fread(*addr,4,1,stream) != 1) || (feof(stream) != NULL) )
  {
    cerr << "Can't read address from file\n";
    exit(-1);
  }
  else
    return 0;
};

int file::writelong(FILE* stream, long* addr)
{
  if ( (fwrite(addr,4,1,stream) != 1) || (ferror(stream) != NULL) )
  {
    cerr << "Can't write address to file\n";
    exit(-1);
  }
  else
    return 0;
};
int file::setposeof(FILE* stream)
{
  int a;

  if ((a = fseek(stream,0L,2)) != NULL)
  {
    cerr << "Can't set file position to end of file (eof)\n";
    exit(-1);
  }
  else
    return a;
};

int file::eof(FILE* stream)
{
  long a;
  int b,c;

  if ((a = ftell(stream)) == -1L)
  {
    cerr << "Can't get file position from file\n";
    exit(-1);
  }
  else if ((b = fgetc(stream)) == EOF)
  {
    clearerr(stream);
    return b;
  }
  else if ((c = fseek(stream,a,0)) != NULL)
  {
    cerr << "Can't set file position in file\n";
    exit(-1);
  }
  else    
    return c;
};
