/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <BitSet.h>
#include "../config/hb_config.hh"
#include "baltree.hh"
#include "Event.hh"

/*******************************************************************
** Global variables
*******************************************************************/

EventClass Tree[NO_OPERATION];
Event AllNodes[NO_OPERATION];
int ShowEventVar[MAXUSERS+1];
int SendEventVar[MAXUSERS+1];


/*******************************************************************
** Fuctions for EVENT
*******************************************************************/

void SetEvent(long EnNo, int UserNr,int Operation, int KeyNr)
{
  int test;
  Event* tmp;
  
  if(EnNo == ALL)
    AllNodes[Operation].Users[UserNr].set(KeyNr);
  else
  {
    tmp = Tree[Operation].search(EnNo);
    if(tmp == NULL)
    {
      tmp = new Event;
      test = Tree[Operation].insert(EnNo,tmp);
    }
    if(KeyNr==ALL)
      tmp->Users[UserNr].set();
    else
      tmp->Users[UserNr].set(KeyNr);
  }
}

int  SetUser(long ent_no,int UserID,int operation,int key)
{
  int test;
  test = CheckPar( ent_no, operation, key);
  if(test == OK)
  {
    if(operation==ALL)
    {
      for(int i=READ;i<NO_OPERATION;i++)
        SetEvent(ent_no,UserID,i,key);
    }
    else
      SetEvent(ent_no,UserID,operation,key);
    return OK;
  }
  else
    return test;
}

/*******************************************************************
** Fuctions for SENDEVENT
*******************************************************************/

void InArraySend(BitSet* a)
{
  int i;
  int count=0;

  for(i=a->first();i>=0;i=a->next(i))
  {
    SendEventVar[count]=i;
    count++;
  }
  SendEventVar[count]=END;
}

void FindUser(BitSet* a, int KeyNr, Event*  User)
{
  for(int i=0;i<MAXUSERS;i++)
  {
    if(!User->Users[i].empty())
    {
      if(User->Users[i].test(ALL))
	a->set(i);
      else if(User->Users[i].test(KeyNr))
	a->set(i);
    }
  }
}  

int CheckEvent(long EnNo, int Operation, int KeyNr)
{
  BitSet a;
  Event* tmp;

  int test;
  test = CheckPar( EnNo, Operation, KeyNr);
  if(test == OK)
  {
    tmp =  &AllNodes[Operation];
    FindUser(&a,KeyNr,tmp);
    tmp = Tree[Operation].search(EnNo);
    if (tmp != NULL)
    FindUser(&a,KeyNr,tmp);
    InArraySend(&a);
    if(SendEventVar[0]==END)
      return NO_SEND_EVENT;
    else
      return OK;
  }
  else
    return test;
}



/*******************************************************************
** Functions for UNEVENT
*******************************************************************/

void CheckForEmpty(Event* tmp,long Input, int Operation)
{
  int bitset = 0;

  for(int i=0;(i<MAXUSERS)&&(!bitset);i++)
    bitset = !tmp->Users[i].empty();
  if(!bitset)
    Tree[Operation].remove(Input);
}

void ClearKey(long Input, int UserNo, int Operation, int key)
{
  Event* tmp;

  tmp = Tree[Operation].search(Input);
  if(tmp != NULL)
  {
    if(key==ALL)
      tmp->Users[UserNo].clear();
    else
      tmp->Users[UserNo].clear(key);
    CheckForEmpty(tmp,Input,Operation);
  }
}

void ClearEvent(long EnNo, int UserNr, int Operation, int key)
{
  long i;
  
  if(EnNo == ALL)
  {
    if(key==ALL)
      AllNodes[Operation].Users[UserNr].clear();
    else
      AllNodes[Operation].Users[UserNr].clear(key);
    for(i=Tree[Operation].first();i!=0;i=Tree[Operation].next(i))
      ClearKey(i,UserNr,Operation,key);
  }
  else
  {
      ClearKey(EnNo,UserNr,Operation,key);
  }
}

int ClearUser(long ent_no,int UserID,int operation,int key)
{
  int test;
  test = CheckPar( ent_no, operation, key);
  if(test == OK)
  {
    if(operation==ALL)
    {
      for(int i=READ;i<NO_OPERATION;i++)
        ClearEvent(ent_no,UserID,i,key);
    }
    else
      ClearEvent(ent_no,UserID,operation,key);
    return OK;
  }
  else
    return test;
}

/*******************************************************************
** Functions for SHOWEVENT
*******************************************************************/

BitSet ShowUser(BitSet a, int KeyNr, Event*  User)
{
  for(int i=0;i<MAXUSERS;i++)
  {
    if(!User->Users[i].empty())
    {
      if(User->Users[i].test(ALL))
	a.set(i);
      else if(User->Users[i].test(KeyNr))
	a.set(i);
    }
  }
  return a;
} 

void InArrayShow(BitSet a)
{
  int i;
  int count=0;

  for(i=a.first();i>=0;i=a.next(i))
  {
    ShowEventVar[count]=i;
    count++;
  }
  ShowEventVar[count]=END;
}
 
int ShowE(long EnNo, int Operation, int KeyNr)
{
  BitSet a;
  Event* tmp;
  
  int test;
  test = CheckPar( EnNo, Operation, KeyNr);
  if(test == OK)
  {
    if(EnNo == ALL)
    {
      tmp =  &AllNodes[Operation];
      a = ShowUser(a,KeyNr,tmp);
    }
    else
    {
      tmp = Tree[Operation].search(EnNo);
      if (tmp != NULL)
	a = ShowUser(a,KeyNr,tmp);
    }
    InArrayShow(a);
    if(ShowEventVar[0]==END)
      return NO_EVENT;
    else
      return OK;
  }
  else
    return test;
}




