/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <BitSet.h>
#include "../config/hb_config.hh"
#include "baltree.hh"
#include "Event.hh"
#include "Lock.hh"
#include "../block2/Operations.hh"
#include "../block4/4a/block3.hh"
#include "MainEL.hh"
#include "MainEventLock.hh"

/*******************************************************************
** Variables for test
*******************************************************************/

Operations  Block2;
hb_block_4a Block4;

/*******************************************************************
** Fuction for converting Key values
*******************************************************************/

int convert(int Input)
{
  switch(Input)
  {
  case ALL:
    return ALL ;
    break;
  case ALLDATA:
    return NODE ;
    break;
  case ALLLINK:
    return LINK ;
    break;
  default:
    if((Input > ALLDATA) && (Input <= DATA))
       return Input - ALLDATA +NODE;
    if((Input > ALLLINK) && (Input <= TODATANODE_NO))
       return Input - ALLLINK + LINK;
    if(Input <= NO_OF_USER_DATA_KEYS)
      return USER + Input - 1;
    if((Input > 255)&&(Input < 256+NO_OF_USER_LINK_KEYS))
      return USER + NO_OF_USER_DATA_KEYS + (256 - Input);
  }
  return ALL; // error
}


/*******************************************************************
** Fuction for SENDEVENT
*******************************************************************/

void EventUser(int UserID,long ent_no,int Operation,int key)
{
  int i;
  int returnval; 
  
  if(CheckEvent(ent_no,Operation,convert(key))==OK)
    for(i=0;SendEventVar[i]!=END;i++)
    {
      returnval = Block4.SendEvent(SendEventVar[i],UserID,ent_no,Operation,key);
    }
}

/*******************************************************************
** Functions for block 2
*******************************************************************/

int EventLock::Write(int UserID,  long ent_no, int key,char *value,long len)
{
  int temp;
  
  if(!IsLockedUser(ent_no,UserID,convert(key)))
  {
    temp = Block2.Write(ent_no,key,value,len);
    if(temp == OK)
      EventUser(UserID,ent_no,WRITE,key);
    return temp;
  }
  else
    return LOCKED;
}

int EventLock::Read(int UserID, long ent_no, int key, char **value, long* len)
{
  int temp;
  
  if(!IsLockedUser(ent_no,UserID,convert(key)))
  {
    temp = Block2.Read(ent_no,key,value,len);
    if(temp == OK)
      EventUser(UserID,ent_no,READ,key);
    return temp;
  }
  else
  {
    temp = Block2.Read(ent_no,key,value,len); // uffe
    if(temp == OK)			      // uffe
      EventUser(UserID,ent_no,READ,key);      // uffe
    return LOCKED;
  }
}

int EventLock::EWrite(int UserID, long ent_no, char *value)
{
  int temp;
  
  if(!IsLockedUser(ent_no,UserID,ALL))
  {
    temp = Block2.EWrite(ent_no,value);
    if(temp == OK)
      EventUser(UserID,ent_no,EWRITE,ALL);
    return temp;
  }
  else
    return LOCKED;
  
}

int EventLock::ERead(int UserID, long ent_no, char **value)
{
  int temp;
  
  if(!IsLockedUser(ent_no,UserID,ALL))
  {
    temp = Block2.ERead(ent_no,value);
    if(temp == OK)
      EventUser(UserID,ent_no,EREAD,ALL);
    return temp; 
  }
  else
    return LOCKED;
}

int EventLock::CreateNode (int UserID,  long* ent_no)
{
  int temp;
  
  temp = Block2.CreateNode(ent_no);
  if(temp == OK)
    EventUser(UserID,*ent_no,CREATE_NODE,ALL);
  return temp; 
}

int EventLock::Delete(int UserID, long ent_no)
{
  int temp;
  if (!AnnyKeyLocked(ent_no))
  {
    temp = Block2.Delete(ent_no);
    if(temp == OK)
      EventUser(UserID,ent_no,DELETE,ALL);
    return temp;
  }
  else
    return 350;  // Locked
}


int EventLock::Link(int UserID, long* ent_no, long ToNode)
{
  int temp;
  
  if(odd(ToNode) == LINKNODE)
  {
    temp = Block2.Link(ent_no,ToNode);
    if(temp == OK)
      EventUser(UserID,*ent_no,LINK,ALL);
    return temp; 
  }
  else
  {
    temp = Block2.Link(ent_no,ToNode);
    if(temp == OK)
      EventUser(UserID,*ent_no,LINK,ALL);
    return temp; 
  }    
}

int EventLock::MoveLink(int UserID, long LinkNo, long NewNode)
{
  int temp;
  
  temp = Block2.MoveLink(LinkNo,NewNode);
  if(temp == OK)
    EventUser(UserID,LinkNo,MOVELINK,ALL);
  return temp; 
}

int EventLock::RemoveLink(int UserID, long ent_no, long link)
{
  int temp;
  
  temp = Block2.RemoveLink(ent_no,link);
  if(temp == OK)
    EventUser(UserID,ent_no,REMOVELINK,ALL);
  return temp; 
}

/*******************************************************************
** Events
*******************************************************************/

int EventLock::Event(int UserID, long ent_no, int operation, int key)
{
  int temp;
  
  temp = SetUser(ent_no,UserID,operation,convert(key));
  if(temp == OK)
    EventUser(UserID,ent_no,EVENT,key);
  return temp; 
}

int EventLock::UnEvent(int UserID, long ent_no, int operation, int key)
{
  int temp;
  
  temp = ClearUser(ent_no,UserID,operation,convert(key));
  if(temp == OK)
    EventUser(UserID,ent_no,UNEVENT,key);
  return temp; 
}

int EventLock::ShowEvent(int UserID, int **usersID, long ent_no, 
			 int operation, int key)
{
  ShowE(ent_no,operation,convert(key));
  *usersID = &ShowEventVar[0];
  EventUser(UserID,ent_no,SHOWEVENT,key);
  return OK;
}

/*******************************************************************
** Locks
*******************************************************************/

int EventLock::Lock(int UserID, long ent_no, int key)
{
  int temp;
  
  temp = LockNode(UserID,ent_no,convert(key));
  if(temp == OK)
    EventUser(UserID,ent_no,LOCK,key);
  return temp;
}

int EventLock::UnLock(int UserID, long ent_no, int key)
{
  int temp;
  
  temp = UnLockNode(UserID,ent_no,convert(key));
  if(temp == OK)
    EventUser(UserID,ent_no,UNLOCK,key);
  return temp;
}

int EventLock::ShowLock(int UserID, int *UserId, long ent_no,int key)
{
  int temp;
  
  temp = ShowLockNode(UserId,ent_no,convert(key));
  if(temp == OK)
    EventUser(UserID,ent_no,SHOWLOCK,key);
  return temp; 
}
/*******************************************************************
** Connect & Disconnect & Browse
*******************************************************************/
int EventLock::Connect(int UserID)
{
  EventUser(UserID,ALL,CONNECT,ALL);
  return OK; 
}

int EventLock::Disconnect(int UserID)
{
  int temp;
  
  temp = UnLockNode(UserID,ALL,ALL);
  temp = ClearUser(ALL,UserID,ALL,ALL);  
  if(temp == OK)
    EventUser(UserID,ALL,DISCONNECT,ALL);
  return temp; 
}

int EventLock::Browse(int UserID,int type, long *value[],long *length)
{
  int temp;
  
  temp = Block2.Browse(type,value,length);
  if(temp == OK)
    EventUser(UserID,ALL,BROWSER,ALL);
  return temp; 
}

