/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include "config.h"
#include "y.tab.h"
#define PREFIX "/bin/cp -r /user/cbn/projekt/src/block[1-5] /user/cbn/projekt/src/Makefile /user/cbn/projekt/src/error.cc"
char *upper(p)
char *p;
{
    char *q = (char *) malloc(sizeof(p));
    char *start ;
    start = q;
    for(;*p != '\0';p++,q++)
	if ((isascii(*p)) && (islower(*p)))
	    *q = toupper(*p);
	else
	    *q = *p;
    return(start);
}

static Symbol *symlist = 0; /* symbol table: linked list */

Symbol *lookup(s) /* find s in symbol table */
char *s;
{
  Symbol *sp;
#ifdef DEBUG
  (void)fprintf(stderr, "lookup for symbol %s\n", s);
#endif  
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
    if (strcmp(sp->name,s) == 0)
      return(sp);
  return 0; /* 0 ==> not found */
}

Symbol *install(s, t, d) /* install s in symbol table */
char *s;
short t;
int d;

{
  Symbol *sp;
  char *emalloc();
  
#ifdef DEBUG
  (void) fprintf( stderr, "istalling %s with type %d and value %d\n", s, t, d);
#endif  
  sp = (Symbol *) emalloc(sizeof(Symbol));
  sp->name = emalloc(strlen(s)+1);
  strcpy(sp->name,s);
  sp->type = t;
  sp->u.val = d;
  sp->next =symlist; /* put at front of list */
  symlist =sp;
  return sp;
}

char *emalloc(n) /* check return from malloc */
unsigned n;
{
    char *p;
    p = (char *) malloc(n);
    if (p == 0)
	execerror("out of memory",(char *) 0);
    return p;
}

show_sym()
{
  Symbol *sp;
  fprintf(stderr,"\n");
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
  {
    fprintf(stderr,"Name :      %s\n",sp->name);
    fprintf(stderr,"Type :      %d\n",sp->type);
    fprintf(stderr,"Value:      %d\n",sp->u.val);
    fprintf(stderr,"\n");
  }
}


create_config()
{
/* Reads from stdin and writes to ./hb_config.cc and ./hb_config.hh.
 * The approach here is very dirty, the correct way of doing things 
 * would be to grasp the values from the symbol table into locals first
 * and then start writing when all values was found and perhaps some 
 * extra checking made
 * CRJ 9/11/89
 */

    
  Symbol *sp;
  char *hyperbaseid = emalloc(9);
  char *tmp = emalloc(128);
  int i = 0;
  int no_of_user_data_keys = 0, no_of_user_link_keys = 0;
  FILE *incl_f, *obj_f;
  
  /* Check that the ID is at most present 1 time, and that all keys are set */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
  {
      if ((strcmp(sp->name,"LINKNUMBERS") != 0) && (strcmp(sp->name,"NUMBER_OF_BLOCK_PTR_IN_DATANODE") !=0 ))
      {
	  if ((sp->type) == ID) i++;
	  if ((((sp->type) == LINKNODE) || ((sp->type) == DATANODE)) && ((sp->u.val == 0)))
	      execerror("Size is not defined for key",sp->name);
	  if ((sp->type) == LINKNODE)
	      no_of_user_link_keys++;
	  if ((sp->type) == DATANODE)
	      no_of_user_data_keys++;
      }
  }
  
  if (i>1)
      warning("The ID is defined more than once, first is used",(char *)0);
  
  /* Check that the musts is defined */
  if ((lookup("DATABLOCKSIZE") == (Symbol *)0) || (lookup("LINKNUMBERS") == (Symbol *)0))
      fprintf(stderr,"\n You must define DATABLOCKSIZE and LINKNUMBERS \n");
  fprintf(stdout,"\n");
  
  /* Open/create the output-files */
  if ((obj_f = fopen("./hb_config.cc","w")) == NULL)
  {
      fprintf(stderr,"Cannot create file ./hbconfig.cc\n");
      exit(1);
  }
if ((incl_f = fopen("./hb_config.hh","w")) == NULL)
  {
      fprintf(stderr,"Cannot create file ./hbconfig.hh\n");
      exit(1);
  }
  

  /* define the enumeration datakeys */
  fprintf(incl_f,"typedef enum { ALLDATA=512, DATANODE_NO, DATASIZE, LINKSTOME, LINKNUM, DATA ");
  fprintf(incl_f," } datakeys; \n");
  
  /* define the enumeratione linkkeys */  
  fprintf(incl_f,"typedef enum { ALLLINK=1024, LINK_NO, USECOUNT, TODATANODE_NO ");
  fprintf(incl_f," } linkkeys; \n");

  /* define the handle/index number for user defined keys in datanode */
  i = 1; /* The number 0 is reserved to reference all  keys ! */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if ((strcmp(sp->name,"LINKNUMBERS") != 0) && 
	  (strcmp(sp->name,"NUMBER_OF_BLOCK_PTR_IN_DATANODE") != 0) &&
	  ((sp->type) == DATANODE) )
      {
	  fprintf(incl_f,"#define %s %d\n",upper(sp->name),i);
	  i++;
      }
  /* define handle for user defined keys in linknode */
  i = 256;
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if ((strcmp(sp->name,"LINKNUMBERS") != 0) && ((sp->type) == LINKNODE))
      {
	  fprintf(incl_f,"#define %s %d\n",upper(sp->name),i);
	  i++;
      }

/* define the enumeration entity-type */
  fprintf(incl_f, "typedef enum { DATANODE, LINKNODE } entity_t; \n");

/* define the enumeration of operations */  
  fprintf(incl_f,"typedef enum  { ALLOP,  READ, WRITE, EREAD, EWRITE, CREATE_NODE, DELETE, LINK, MOVELINK, REMOVELINK, EVENT, UNEVENT, SHOWEVENT, LOCK, UNLOCK, SHOWLOCK, CONNECT, DISCONNECT, BROWSER  } operations;\n");

  fprintf(incl_f,"#define NO_OPERATION 19\n");
  
/* define the hyperbase identity */
  hyperbaseid = "HYPERBASE";
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
    if ((sp->type) == ID)
      hyperbaseid = sp->name;
  fprintf(incl_f,"#define HYBERBASEID \"%s\"\n",hyperbaseid);

/* define the socket number for initial communication */
  if ((sp = lookup("SOCKETID")) != (Symbol *)0)
      fprintf(incl_f,"#define SOCKETID %d\n",sp->u.val);
  else
      fprintf(incl_f,"#define SOCKETID 10023\n");
  
/* define the number of user defined keys */
  fprintf(incl_f,"#define NO_OF_USER_DATA_KEYS %d\n",no_of_user_data_keys);
  fprintf(incl_f,"#define NO_OF_USER_LINK_KEYS %d\n",no_of_user_link_keys);

/* define the size of the user defined keys in links and nodes */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if (((strcmp(sp->name,"LINKNUMBERS") != 0)) && 
	  (strcmp(sp->name,"NUMBER_OF_BLOCK_PTR_IN_DATANODE")!= 0) &&
	  ((sp->type == LINKNODE) || (sp->type == DATANODE)))
	  fprintf(incl_f,"#define %s_SIZE %d \n",sp->name,sp->u.val);

/* define number of direct links in datanode */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
    if ( (strcmp((sp->name),"LINKNUMBERS") == 0) && 
	((sp->type) == DATANODE))
	fprintf(incl_f,"#define NO_OF_LINKS_IN_DATANODE %d\n", sp->u.val);

/* define number of direct links in link nodes */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
    if ((strcmp((sp->name),"LINKNUMBERS") == 0) && ((sp->type) == LINKNODE))
      fprintf(incl_f,"#define NO_OF_LINKS_IN_LINKNODE %d\n", sp->u.val);

/* */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if((strcmp((sp->name),"NUMBER_OF_BLOCK_PTR_IN_DATANODE") == 0))
      {
	  fprintf(incl_f,"#define NUMBER_OF_BLOCK_PTR_IN_DATANODE %d\n",sp->u.val);
	  break;
      }
  
/* Otherwise use a default */
if ( sp == (Symbol *)0 )
    fprintf(incl_f,"#define NUMBER_OF_BLOCK_PTR_IN_DATANODE 5\n");
  
/* define blocksize */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if (((strcmp(sp->name,"DATABLOCKSIZE") == 0)) && (sp->type == DEFINED))
      {
	  fprintf(incl_f,"#define DATABLOCKSIZE %d\n", sp->u.val);
	  break;
      }
  
  
  /* define maxusers */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if (((strcmp(sp->name,"MAXUSERS") == 0)) && (sp->type == DEFINED))
      {
	  fprintf(incl_f,"#define MAXUSERS %d\n", sp->u.val);
	  break;
      }
  
  if ( sp == (Symbol *)0 )
	fprintf(incl_f,"#define MAXUSERS 32\n");

/* define the size of the user defined keys in links and nodes */
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if (((strcmp(sp->name,"LINKNUMBERS") != 0)) && 
	  (strcmp(sp->name,"NUMBER_OF_BLOCK_PTR_IN_DATANODE") != 0) &&
	  ((sp->type == LINKNODE) || (sp->type == DATANODE)))
	  fprintf(incl_f,"#define %s_SIZE %d \n",sp->name,sp->u.val);

  /* define the structure of datanode */
  fprintf(incl_f,"struct datanode {\n");
  fprintf(incl_f,"\t long datanode_no;\n");
  fprintf(incl_f,"\t long size;\n");
  fprintf(incl_f,"\t long links_to_me;\n");
  fprintf(incl_f,"\t long linknum[NO_OF_LINKS_IN_DATANODE];\n");
  fprintf(incl_f,"\t long datalinkptr;\n");
  fprintf(incl_f,"\t long double_datalinkptr;\n");
  fprintf(incl_f,"\t long blockptr [NUMBER_OF_BLOCK_PTR_IN_DATANODE];\n");
  fprintf(incl_f,"\t long datablockptr;\n");
  fprintf(incl_f,"\t long double_datablockptr;\n");
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
    if (((strcmp(sp->name,"LINKNUMBERS") != 0) && 
	 (strcmp(sp->name,"NUMBER_OF_BLOCK_PTR_IN_DATANODE") != 0) && 
	 (sp->type == DATANODE)))
	fprintf(incl_f,"\t char %s[%s_SIZE];\n",sp->name, sp->name);
  fprintf(incl_f,"};\n");

  /* define the structure of link_node */
  fprintf(incl_f,"struct linknode {\n");
  fprintf(incl_f,"\t long linknode_no;\n");
  fprintf(incl_f,"\t long usecount;\n");  
  fprintf(incl_f,"\t long to_datanode_no;\n");
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next
)    if (((strcmp(sp->name,"LINKNUMBERS") != 0)) && (sp->type == LINKNODE))
      fprintf(incl_f,"\t char %s[%s_SIZE];\n",sp->name, sp->name);
  fprintf(incl_f,"};\n");

/* define an static array giving the index for datanode userkeys*/
  fprintf(obj_f,"#include \"hb_config.hh\"\n");
  fprintf(obj_f,"datanode *q = new datanode;\n");
  fprintf(obj_f,"linknode *p = new linknode;\n");
  fprintf(obj_f,"static unsigned long dataoffset[ %d ] = { ",no_of_user_data_keys);
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if (((strcmp(sp->name,"LINKNUMBERS") != 0)) && 
	  (strcmp(sp->name,"NUMBER_OF_BLOCK_PTR_IN_DATANODE") !=0) &&
	  (sp->type == DATANODE))
	  fprintf(obj_f,"(char *)(q->%s) - (char *)(q),\n\t",sp->name);
  fprintf(obj_f,"};\n");

  /* define an static array giving the index for link-node userkeys */
  fprintf(obj_f,"static unsigned long linkoffset[ %d ] = { ",no_of_user_link_keys);
  for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
      if (((strcmp(sp->name,"LINKNUMBERS") != 0)) && (sp->type == LINKNODE))
	  fprintf(obj_f,"(char *)(p->%s) - (char *)(p),\n\t",sp->name);
  fprintf(obj_f,"};\n");
    
/* Define a global array containing the names,len of user keys in DATA*/
  i = 0;
  fprintf(obj_f,"#define DATA_OPTIONS { ");
    for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
    if (((strcmp(sp->name,"LINKNUMBERS") != 0)) && 
	(strcmp(sp->name,"NUMBER_OF_BLOCK_PTR_IN_DATANODE") != 0) &&
	(sp->type == DATANODE))
    {
	if (i == 0)
	{
	    fprintf(obj_f,"{\"%s\",%d} \\\n",sp->name, sp->u.val);
	    i++;
	}
	else
	    fprintf(obj_f,",{\"%s\",%d} \\\n",sp->name, sp->u.val);
    }
  fprintf(obj_f, "}\n");
  
/* Define a global array containing the names,len of user keys in LINK */
  i = 0;
  fprintf(obj_f,"#define LINK_OPTIONS { ");
    for(sp = symlist; sp != (Symbol *)0; sp = sp->next)
    if (((strcmp(sp->name,"LINKNUMBERS") != 0)) && (sp->type == LINKNODE))
    {
	if (i == 0)
	{
	    fprintf(obj_f,"{\"%s\",%d} \\\n",sp->name, sp->u.val);
	    i++;
	}
	else
	    fprintf(obj_f,",{\"%s\",%d} \\\n",sp->name, sp->u.val);
    }
  fprintf(obj_f,"}\n");

/* Create the static array containing user keys in links and datanodes */
  fprintf(obj_f,"struct data_keys\n{\n\tchar *name;\n\t int length;\n} user_data_keys[] = DATA_OPTIONS;\n");
  fprintf(obj_f,"struct link_keys\n{\n\tchar *name;\n\t int length;\n} user_link_keys[] = LINK_OPTIONS;\n");

  fprintf(obj_f, "int no_of_user_link_keys = NO_OF_USER_LINK_KEYS;\n");
  fprintf(obj_f , "int no_of_user_data_keys = NO_OF_USER_DATA_KEYS;\n");

  /* Create the directory to compile the HyperBase in */
  if ( (mkdir(hyperbaseid,509)) != 0)
  {
      fprintf(stderr,"Cannot create directory %s \n",hyperbaseid);
      fprintf(stderr,"Include files have been created\n");
      exit(1);
  }
  /* Copy the sourcecode for HyperBase to the directory where 
   * we want to compile our HyperBase.
   */
  fprintf(stderr,"Setting directory %s up for compilation\n", hyperbaseid);
  strcat(tmp, PREFIX);
  strcat(tmp, " ");
  strcat(tmp, hyperbaseid);
  system(tmp);

  /* Move the 2 configurations files into the compile-directory */
  tmp="\0";
  strcat(tmp,"/bin/mv hb_config.hh hb_config.cc ");
  strcat(tmp, hyperbaseid);
  system(tmp);
}


    
