.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfIcon
.SH DESCRIPTION
The XfwfIcon widget displays an image. The preferred width and
height of the widget will be set to the width and height of the loaded
image, plus space for the frame. The widget has a callback
\fIactivateCallback\fP, that is by default bound to a click of the left
mouse button.

The image is a \fIPixmap\fP, optionally accompanied by a mask, to make
parts of the image transparent. When the image has a mask, the frame
around the widget will not be shown.

.SS "Public variables"

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfIcon
Name	Class	Type	Default
XtNimage	XtCImage	Icon *	NULL 
XtNactivate	XtCActivate	Callback	NULL 

.TE
.ps

.TP
.I "XtNimage"
The image must be in \fIPixmap\fP format. The width and height of the
image will be used to set the width and height of the widget.  There
is a converter for strings (defined in the Common widget), which will
try to interpret a string as a file name and load the file. The file
must be in XPM format. The converter also knows about some built-in
images, called \fI"FATAL"\fP, \fI"ERROR"\fP, \fI"WARNING"\fP, \fI"QUESTION"\fP,
\fI"INFO"\fP and \fI"NONE"\fP.

	

.hi

.nf
Icon * image = NULL 
.fi

.eh

.TP
.I "XtNactivate"
The callback is called by the \fIactivate\fP action, which is by default
bound to a click of mouse button 1.

	

.hi

.nf
<Callback> XtCallbackList  activate = NULL 
.fi

.eh

.TP
.I "XtNframeWidth"
By default, icons do not have a frame.

	

.hi

.nf
 frameWidth = 0 
.fi

.eh

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps

.SS "Exports"

The type \fIIcon\fP is defined in \fIConverters.h\fP

.nf

.B incl
 <Xfwf/Converters.h>
.fi

.SS "Translations"

By default, the \fIactivate\fP action is bound to a mouse click and to
the Return key.

	

.nf
<Btn1Down>,<Btn1Up>: activate() 
.fi

.nf
<Key>Return: activate() 
.fi

.hi
.SS "Actions"

.TP
.I "activate

The \fIactivate\fP action just calls the \fIactivate\fP callback functions,
passing the \fIXEvent\fP pointer in the \fIcall_data\fP argument.

.hi

.nf
void activate($, XEvent* event, String* params, Cardinal* num_params)
{
    XtCallCallbackList($, $activate, event);
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <X11/extensions/shape.h>
.fi

.nf

.B incl
 <stdio.h>
.fi

.hi

.hi
.SS "Private variables"

The GC for drawing the image.

	

.nf
GC  image_gc
.fi

.hi

.hi
.SS "Methods"

The \fIinitialize\fP sets the (desired and actual) size of the widget to
the size of the image. The GC is initialized.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Dimension dummy1, dummy2;
    Position x, y;

    $image_gc = NULL;
    create_image_gc($);
    if ($image  ($image->attributes.valuemask  XpmSize) != 0) {
	$compute_inside($, x, y, dummy1, dummy2);
	XtVaSetValues($, XtNwidth, $image->attributes.width + 2*x,
		      XtNheight, $image->attributes.height + 2*y, NULL);
    }
}
.fi

The \fIexpose\fP method simply draws the image (if any) against the top
left corner of the widget. The window is first masked with the image's
mask. After that the images is drawn with a call to \fIXFillRectangle\fP.
The GC is queried first, to see if the origin needs changing.
Unfortunately, this involves a round trip to the server.  Finally,
\fIexpose\fP calls the superclass's \fIexpose\fP method to draw the frame.

.nf
expose($, XEvent * event, Region  region)
{
    Dimension wd, ht;
    Position x, y;

    if (! XtIsRealized($)) return;
    if ($image  $image->pixmap != None) {
	$compute_inside($, x, y, wd, ht);
	XFillRectangle(XtDisplay($), XtWindow($), $image_gc, x, y, wd, ht);
    }
    #expose($, event, region);
}
.fi

A change of image also causes a change in size.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Dimension dummy1, dummy2;
    Position x, y;
    Boolean need_redraw = False;

    if ($old$frameWidth != $frameWidth
	|| $old$outerOffset != $outerOffset
	|| $old$image != $image) {
	create_image_gc($);
	need_redraw = True;
    }
    if ($old$image != $image  $image) {
	$compute_inside($, x, y, dummy1, dummy2);
	if (($image->attributes.valuemask  XpmSize) != 0)
	    $set_abs_location($, CWWidth | CWHeight, 0, 0,
			      $image->attributes.width + 2*x,
			      $image->attributes.height + 2*y);
	if ($image->mask != None  XtIsRealized($))
	    XShapeCombineMask(XtDisplay($), XtWindow($), ShapeBounding,
			      x, y, $image->mask, ShapeSet);
	need_redraw = True;
    }
    return need_redraw;
}
.fi

When the Widget is realized, the window is immediately combined with
the icon's mask.

.nf
realize($, XtValueMask * mask, XSetWindowAttributes * attributes)
{
    Dimension wd, ht;
    Position x, y;

    #realize($, mask, attributes);
    $compute_inside($, x, y, wd, ht);
    if ($image  $image->mask != None)
	XShapeCombineMask(XtDisplay($), XtWindow($), ShapeBounding,
			  x, y, $image->mask, ShapeSet);
}
.fi

.hi

.hi
.SH "Utilities"

The GC is created by a utility function. It sets the fill style to
\fIFillTiled\fP and the origin to the coordinates just inside the widget's
frame

.nf
create_image_gc($)
{
    Dimension wd, ht;
    Position x, y;
    XtGCMask mask = GCFillStyle | GCTileStipXOrigin | GCTileStipYOrigin;
    XGCValues values;

    if ($image_gc != NULL) XtReleaseGC($, $image_gc);
    $compute_inside($, x, y, wd, ht);
    if ($image  $image->pixmap != None) {
	values.tile = $image->pixmap;
	mask |= GCTile;
    }
    values.fill_style = FillTiled;
    values.ts_x_origin = x;
    values.ts_y_origin = y;
    $image_gc = XtGetGC($, mask, values);
}
.fi

.hi
