.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfTabs
.SH DESCRIPTION
The \fIXfwfTabs\fP widget displays a series of tabs, similar to the
alphabet tabs along the top of index cards. One tab, the front one, is
completely visible, the others are partially hidden behind it. Each of
the tabs can be clicked on with the mouse.

Although \fIXfwfTabs\fP is a descendant of \fIXfwfBoard\fP, \fIXfwfFrame\fP and
\fIXfwfCommon\fP, it does not currently use many of the resources defined
by those classes. In particular, this implementation does not take
part in keyboard traversal, and it has no 3D frame. The only resources
that it uses are the location resources defined in \fIXfwfBoard\fP.

.SS "Public variables"

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfTabs
Name	Class	Type	Default
XtNlefttabs	XtCLefttabs	Int 	0 
XtNrighttabs	XtCRighttabs	Int 	0 
XtNlabels	XtCLabels	StringArray 	NULL 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNlinecolor	XtCLinecolor	Pixel 	XtDefaultForeground 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNactivate	XtCActivate	Callback	NULL 

.TE
.ps

.TP
.I "XtNlefttabs"
\fIlefttabs\fP is the number of partially visible tabs to the left of
the main one. The main tab always occupies the same amount of space,
but the tabs to the left become narrower when \fIlefttabs\fP is increased.

	

.hi

.nf
int  lefttabs = 0 
.fi

.eh

.TP
.I "XtNrighttabs"
The number of tabs to the right of the main one. The higher the
number, the smaller the tabs will be.

	

.hi

.nf
int  righttabs = 0 
.fi

.eh

.TP
.I "XtNlabels"
The labels on each of the tabs must be simple strings. There is no
support for multiline labels or different fonts in this version of
\fIXfwfTabs\fP. The array \fIlabels\fP should contain no less than \fIlefttabs +
righttabs + 1\fP strings. The widget makes private copies of the array
and of the strings.

The leftmost tab displays \fIlabels[0]\fP. Note that the labels may be too
large to fit in the tab. In that case they are clipped. The left tabs
show only the initial part of the labels, the right tabs show the last
part of their labels and the main (front) tab shows the middle part of
its label.

	

.hi

.nf
StringArray  labels = NULL 
.fi

.eh

.TP
.I "XtNforeground"
The color of the text.

	

.hi

.nf
Pixel  foreground = <String>XtDefaultForeground 
.fi

.eh

.TP
.I "XtNlinecolor"
The color of the lines around the tabs.

	

.hi

.nf
Pixel  linecolor = <String>XtDefaultForeground 
.fi

.eh

.TP
.I "XtNfont"
The text is drawn in the font which is give as the \fIfont\fP resource.

	

.hi

.nf
<FontStruct> XFontStruct * font = <String>XtDefaultFont 
.fi

.eh

.TP
.I "XtNactivate"
When the user clicks on a tab, a callback function is called. The
\fIcall_data\fP argument to the callback will be a relative number: 0 if
the user clicked on the main tab, -1 if he clicked on the tab
immediately to the left, +1 if he clicked on the first right tab, and
higher numbers for tabs that are further removed from the main one.

	

.hi

.nf
<Callback> XtCallbackList  activate = NULL 
.fi

.eh

.TP
.I "XtNtraversalOn"
Currently no keyboard traversal.

	

.hi

.nf
 traversalOn = False 
.fi

.eh

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps

.SS "Exports"

.nf

.B type
 StringArray = String *
.fi

.SS "Translations"

.nf
<Btn1Down>,<Btn1Up>: activate() 
.fi

.hi
.SS "Actions"

.TP
.I "activate

.hi

.nf
void activate($, XEvent* event, String* params, Cardinal* num_params)
{
    Dimension w, delta, ww, w1, w2;
    int i;

    delta = ($height - event->xbutton.y)/2;
    w = $lefttabs + $righttabs == 0 ? 0 : $width/2/($lefttabs + $righttabs);
    w1 = $lefttabs == 0 ? 0 : $lefttabs * w;
    w2 = $righttabs == 0 ? 0 : $righttabs * w;

    if (event->xbutton.x < w1 + delta) {
	/* Click left of main tab */
	if ($lefttabs != 0) {
	    ww = w + delta;
	    for (i = -$lefttabs; event->xbutton.x >= ww; i++, ww += w) ;
	    XtCallCallbackList($, $activate, (XtPointer) i);
	}
    } else if (event->xbutton.x < $width - w2 - delta) {
	/* Click on main tab */
	XtCallCallbackList($, $activate, (XtPointer) 0);
    } else {
	/* Click right of main tab */
	if ($righttabs != 0) {
	    ww = $width - w - delta;
	    for (i = $righttabs; event->xbutton.x < ww; i--, ww -= w) ;
	    XtCallCallbackList($, $activate, (XtPointer) i);
	}
    }
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <X11/extensions/shape.h>
.fi

.hi

.hi
.SS "Private variables"

A GC for drawing the labels.

	

.nf
GC  textgc
.fi

A GC for drawing the lines.

	

.nf
GC  linegc
.fi

.hi

.hi
.SS "Methods"

The \fIinitialize\fP method checks the resources and creates the local
variables.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    $linegc = NULL;
    create_linegc($);
    $textgc = NULL;
    create_textgc($);
    if ($labels) {
	String *h;
	int i;
	h = (String*) XtMalloc(($lefttabs + $righttabs + 1) * sizeof(h[0]));
	for (i = $lefttabs + $righttabs; i >= 0; i--)
	    h[i] = XtNewString($labels[i]);
	$labels = h;
    }
}
.fi

The \fIset_values\fP method checks changed resources and recomputes some
local variables. In this case the GC's may have to be changed.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Boolean redraw = False;

    if ($foreground != $old$foreground || $font != $old$font) {
	create_textgc($);
	redraw = True;
    }
    if ($linecolor != $old$linecolor) {
	create_linegc($);
	redraw = True;
    }
    if ($labels != $old$labels) {
	String *h;
	int i;
	h = (String*) XtMalloc(($lefttabs + $righttabs + 1) * sizeof(h[0]));
	for (i = $lefttabs + $righttabs; i >= 0; i--)
	    h[i] = XtNewString($labels[i]);
	for (i = $old$lefttabs + $old$righttabs; i >= 0; i--)
	    XtFree($old$labels[i]);
	XtFree((XtPointer) $old$labels);
	$labels = h;
	redraw = True;
    }
    if ($lefttabs != $old$lefttabs || $righttabs != $old$righttabs)
	redraw = True;

    return redraw;
}
.fi

When the widget is realized or resized, a new shape mask is
installed. The shape mask makes the corners transparent.

.nf
realize($, XtValueMask * mask, XSetWindowAttributes * attributes)
{
    Region region;
    Dimension delta;
    XPoint poly[7];

    #realize($, mask, attributes);
    delta = $height/2;
    /*
     *     2 o------------------o 3
     *      /                    \\
     *     /                      \\
     *  1 o                        o 4
     *  0 o------------------------o 5
     */
    poly[0].x = 0;		poly[0].y = $height;
    poly[1].x = 0;		poly[1].y = $height - 1;
    poly[2].x = delta;		poly[2].y = 0;
    poly[3].x = $width - delta;	poly[3].y = 0;
    poly[4].x = $width;		poly[4].y = $height - 1;
    poly[5].x = $width;		poly[5].y = $height;
    poly[6] = poly[0];

    region = XPolygonRegion(poly, 7, EvenOddRule);
    XShapeCombineRegion(XtDisplay($), XtWindow($), ShapeBounding,
			0, 0, region, ShapeSet);
    XDestroyRegion(region);
}
.fi

.nf
resize($)
{
    Region region;
    Dimension delta;
    XPoint poly[7];

    #resize($);
    delta = $height/2;

    poly[0].x = 0;		poly[0].y = $height;
    poly[1].x = 0;		poly[1].y = $height - 1;
    poly[2].x = delta;		poly[2].y = 0;
    poly[3].x = $width - delta;	poly[3].y = 0;
    poly[4].x = $width;		poly[4].y = $height - 1;
    poly[5].x = $width;		poly[5].y = $height;
    poly[6] = poly[0];

    region = XPolygonRegion(poly, 7, EvenOddRule);
    XShapeCombineRegion(XtDisplay($), XtWindow($), ShapeBounding,
			0, 0, region, ShapeSet);
    XDestroyRegion(region);
}
.fi

The \fIexpose\fP method draws the tabs. First the tabs to the left, then
the tabs to the right, and finally the main one. Three private
routines do most of the work. The inherited \fIexpose\fP method is called
to draw the frame, if any, although the tabs should look best without
a frame.

.nf
expose($, XEvent * event, Region  region)
{
    int i;
    Dimension width, height;
    Position x, y;

    if (! XtIsRealized($)) return;
    #expose($, event, region);
    for (i = 0; i < $lefttabs; i++)
	draw_left_tab($, region, i);
    for (i = $lefttabs + 1; i <= $lefttabs + $righttabs; i++)
	draw_right_tab($, region, i);
    draw_main_tab($, region);
}
.fi

.hi

.hi
.SH "Utilities"

The \fIdraw_left_tab\fP routine draws a narrow tab to the left of the
main one. The \fIpoly\fP variable holds the corner points of the area
occupied by this tab, which looks like a lozenge, or a rectangle
bending to the right. The label is written inside this area,
left-aligned.

\fBdef\fP MARGIN = 2 

.nf
draw_left_tab($, Region  region, int  i)
{
    Region clip;
    XPoint poly[5];
    Dimension w, delta;
    Position x1, y1;

    w = $width/2/($lefttabs + $righttabs);
    delta = $height/2;				/* Skew */

    /*
     *    2 o--------o 3
     *     /
     *    /
     * 1 o--------o 0
     */
    poly[0].x = i * w + w - 1;          poly[0].y = $height - 1;
    poly[1].x = i * w;                  poly[1].y = $height - 1;
    poly[2].x = i * w + delta;          poly[2].y = 0;
    poly[3].x = i * w + w + delta - 1;  poly[3].y = 0;
    poly[4] = poly[0];

    clip = XPolygonRegion(poly, 5, EvenOddRule);
    if (region) XIntersectRegion(clip, region, clip);
    XSetRegion(XtDisplay($), $textgc, clip);

    if ($labels) {
	y1 = ($height - $font->ascent - $font->descent)/2;
	x1 = i * w + ($height - y1)/2 + MARGIN;
	XDrawString(XtDisplay($), XtWindow($), $textgc, x1, y1 + $font->ascent,
		    $labels[i], strlen($labels[i]));
    }
    XDrawLines(XtDisplay($), XtWindow($), $linegc, poly, 4, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

.nf
draw_right_tab($, Region  region, int  i)
{
    Region clip;
    XPoint poly[5];
    Dimension w, delta, textw, len;
    Position x1, y1;

    w = $width/2/($lefttabs + $righttabs);
    delta = $height/2;				/* Skew */

    /*
     * 0 o--------o 1
     *             \\
     *              \\
     *    3 o--------o 2
     */
    x1 = $width - w * ($lefttabs + $righttabs - i);
    poly[0].x = x1 - w - delta;  poly[0].y = 0;
    poly[1].x = x1 - delta - 1;  poly[1].y = 0;
    poly[2].x = x1 - 1;          poly[2].y = $height - 1;
    poly[3].x = x1 - w;          poly[3].y = $height - 1;
    poly[4] = poly[0];

    clip = XPolygonRegion(poly, 4, EvenOddRule);
    if (region) XIntersectRegion(region, clip, clip);
    XSetRegion(XtDisplay($), $textgc, clip);

    if ($labels) {
	len = strlen($labels[i]);
	textw = XTextWidth($font, $labels[i], len);
	y1 = ($height - $font->ascent - $font->descent)/2;
	x1 = x1 - ($height - y1)/2 - textw - MARGIN;
	XDrawString(XtDisplay($), XtWindow($), $textgc, x1, y1 + $font->ascent,
		    $labels[i], len);
    }
    XDrawLines(XtDisplay($), XtWindow($), $linegc, poly, 4, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

.nf
draw_main_tab($, Region  region)
{
    Dimension textw, w1, w2, delta, w, len;
    Position x1, y1;
    Region clip;
    XPoint poly[6];

    delta = $height/2;
    w = $width/2/($lefttabs + $righttabs);
    w1 = $lefttabs == 0 ? 0 : $lefttabs * w;
    w2 = $righttabs == 0 ? 0 : $righttabs * w;

    /*
     *          2 o-------------o 3
     *           /               \\
     *          /                 \\
     * 0 ------o 1               4 o------o 5
     */
    poly[0].x = 0;                    poly[0].y = $height - 1;
    poly[1].x = w1;                   poly[1].y = $height - 1;
    poly[2].x = w1 + delta;           poly[2].y = 0;
    poly[3].x = $width - w2 - delta;  poly[3].y = 0;
    poly[4].x = $width - w2;          poly[4].y = $height - 1;

    poly[5] = poly[1];

    clip = XPolygonRegion(poly + 1, 5, EvenOddRule);

    poly[5].x = $width;               poly[5].y = $height;

    if (region) XIntersectRegion(clip, region, clip);
    XSetRegion(XtDisplay($), $textgc, clip);

    if ($labels) {
	len = strlen($labels[$lefttabs]);
	textw = XTextWidth($font, $labels[$lefttabs], len);
	x1 = (w1 + $width - w2)/2 - textw/2;
	y1 = ($height - $font->ascent - $font->descent)/2 + $font->ascent;
	XDrawString(XtDisplay($), XtWindow($), $textgc, x1, y1,
		    $labels[$lefttabs], len);
    }
    XDrawLines(XtDisplay($), XtWindow($), $linegc, poly, 6, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

The GCs are not shared, because the clip masks are changed
sometimes.

.nf
create_linegc($)
{
    XtGCMask mask;
    XGCValues values;

    if ($linegc != NULL) XFreeGC(XtDisplay($), $linegc);
    values.foreground = $linecolor;
    mask = GCForeground;
    $linegc = XCreateGC(XtDisplay($), RootWindowOfScreen(XtScreen($)),
		    mask, values);
}
.fi

.nf
create_textgc($)
{
    XtGCMask mask;
    XGCValues values;

    if ($textgc != NULL) XFreeGC(XtDisplay($), $textgc);
    values.foreground = $linecolor;
    values.font = $font->fid;
    mask = GCForeground | GCFont;
    $textgc = XCreateGC(XtDisplay($), RootWindowOfScreen(XtScreen($)),
		    mask, values);
}
.fi

.hi
