/*
 * Author:
 * 	Brian Totty
 * 	Department of Computer Science
 * 	University Of Illinois at Urbana-Champaign
 *	1304 West Springfield Avenue
 * 	Urbana, IL 61801
 * 
 * 	totty@cs.uiuc.edu
 * 	
 */ 

#include <stdio.h>
#include <Xfwf/DirMgr.h>

int main(argc,argv)
int argc;
char **argv;
{
	DIRECTORY_MGR *dm;
	DIR_ENTRY *de;
	char *path,*pat;
	int sort_mode;

	if (argc != 3 && argc != 4)
	{
		fprintf(stderr,"usage: %s path sort_mode [pattern]\n",argv[0]);
		exit(-1);
	}
	path = argv[1];
	sort_mode = atoi(argv[2]);
	if (argc == 4)
		pat = argv[3];
	    else
		pat = NULL;
	dm = DirectoryMgrSimpleOpen(path,sort_mode,pat);
	if (dm == NULL)
	{
		fprintf(stderr,"Can't open directory mgr for '%s'\n",path);
		exit(-1);
	}
	while (1)
	{
		de = DirectoryMgrNextEntry(dm);
		if (de == NULL) break;
		DirEntryDump(stderr,de);
	}

	printf("Changing sort mode to 1\n");
	DirectoryMgrSimpleResort(dm,1);
	while (1)
	{
		de = DirectoryMgrNextEntry(dm);
		if (de == NULL) break;
		DirEntryDump(stderr,de);
	}


	DirectoryMgrClose(dm);
	return(1);
}
