#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xfwf/Group.h>
#include <Xfwf/Button.h>
#include <Xfwf/Toggle.h>

static XtAppContext app_context;
static Widget toplevel, board, group, t[6], quit_button;

static String fallback_resources[] = {
    "*board.width: 500",			/* Overall size */
    "*board.height: 400",

    "ToggleT*borderWidth: 0",			/* Global */
    "ToggleT*background: aquamarine",

    /*
     * The next 3 resources keep the group a fixed width, but the
     * height is calculated from the total height of the children.
     */
    "ToggleT*group.location: 0.5-130 20 260 280",
    "ToggleT*group.columns: 1",
    "ToggleT*group.shrinkToFit: True",
    "ToggleT*group.label: \\ Choose one:\\ ",
    "ToggleT*group.foreground: yellow",
    "ToggleT*group.font: *-helvetica-bold-r-*-140-*",
    "ToggleT*group.outerOffset: 8",
    "ToggleT*group.innerOffset: 8",
    "ToggleT*group.frameWidth: 4",

    /*
     * The position of the toggle buttons is set by the group widget,
     * but the width and height are acknowledged. The buttons will
     * have (by default) maximum width and be 40 pixels high.
     */
    "ToggleT*XfwfToggle.abs_height: 40",
    "ToggleT*XfwfToggle.rel_height: 0.0",
    "ToggleT*XfwfToggle.outerOffset: 1",
    "ToggleT*XfwfToggle.innerOffset: 3",
    "ToggleT*XfwfToggle.alignment: left",

    "ToggleT*0.label: orange",
    "ToggleT*1.label: apple",
    "ToggleT*2.label: melon",
    "ToggleT*3.label: grapefruit",
    "ToggleT*4.label: strawberry",
    "ToggleT*5.label: banana",

    "ToggleT*quit.abs_height: 40",
    "ToggleT*quit.rel_height: 0.0",
    "ToggleT*quit.outerOffset: 1",
    "ToggleT*quit.label: Quit",

    NULL,
};


static void quit(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    long selection;
    String s;

    XtVaGetValues(group, XtNselection, &selection, NULL);
    if (selection == -1L)
	printf("Nothing was selected\n");
    else {
	XtVaGetValues(t[selection], XtNlabel, &s, NULL);
	printf("The final selection was: %s\n", s);
    }
    exit(0);
}


void main(argc, argv)
    int argc;
    char *argv[];
{
    toplevel = XtVaAppInitialize(&app_context, "ToggleT", NULL, 0,
				 &argc, argv, fallback_resources, NULL);
    board = XtVaCreateManagedWidget("board", xfwfBoardWidgetClass,
				    toplevel, NULL);
    group = XtVaCreateManagedWidget("group", xfwfGroupWidgetClass,
				    board, NULL);
    t[0] = XtVaCreateManagedWidget("0", xfwfToggleWidgetClass, group, NULL);
    t[1] = XtVaCreateManagedWidget("1", xfwfToggleWidgetClass, group, NULL);
    t[2] = XtVaCreateManagedWidget("2", xfwfToggleWidgetClass, group, NULL);
    t[3] = XtVaCreateManagedWidget("3", xfwfToggleWidgetClass, group, NULL);
    t[4] = XtVaCreateManagedWidget("4", xfwfToggleWidgetClass, group, NULL);
    t[5] = XtVaCreateManagedWidget("5", xfwfToggleWidgetClass, group, NULL);
    quit_button = XtVaCreateManagedWidget("quit", xfwfButtonWidgetClass,
					  group, NULL);
    XtAddCallback(quit_button, XtNactivate, quit, NULL);
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_context);
}
