'\" t
.TH "ScrolledList" "3" "9 Jan 1993" "Version 3.0" "Free Widget Foundation"
.SH NAME
ScrolledList \- A Single Column Scrolling List Of Strings
.SH DESCRIPTION
.PP
.I ScrolledList
is a simple, single column, scrolled list of text items, where
selections can be made.  The widget has callbacks to notify selection
changes.  The ScrolledList is build from the MultiList widget allowing
the text highlight colors to be changed, and multiple items to be
selected.  This is a very incomplete widget -- read the RESTRICTIONS
section below.
.SH CLASS HIERARCHY
.LP
Core
Composite
.SH RESOURCES
.TS
tab(/) ;
lB lB lB lB lB.
Name/Class/Type/Notes/Default
.T&
lB l l l l.
XtNwidth/Width/Dimension/ /200
XtNheight/Height/Dimension/ /500
XtNbackground/Background/Pixel/ /white
XtNlist/Pointer/char**/ /NULL
XtNnumberStrings/NumberStrings/Int/ /0
XtNsensitiveArray/Pointer/Boolean */ /NULL
XtNcallback/Callback/Callback/NULL
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.nf
.ta 3i
void ScrolledListSetList(w,newlist,items,resize,sensitive_array)
Widget w;
char **newlist;
int items;
Boolean resize;
Boolean *sensitive_array;
.fi
.sp
.RS 5
This routine tries to set the string array to the new array <newlist>.
<items> is the count of strings.  If <items> is 0 and the array is
NULL terminated, the number of strings will be automatically counted.
The <resize> flag indicates if we want the widget to try to resize
itself to hold the new array.  The <sensitive_array> parameter
(if non-NULL) contains an array of Booleans representing the
sensitivity of the list items.

This routine is the primary interface to changing the data.  The
resources XtNlist, XtNnumberStrings, and XtNsensitiveArray can be
changed in parallel, but all three values must be changed within a
single SetValues call.  It is better, and more flexible, to use this
function interface.
.RE
.sp
.nf
void ScrolledListUnhighlightAll(w)
Widget w;
.fi
.sp
.RS 5
This routine unhighlights all highlighted items in the ScrolledList
widget <w>.
.RE
.sp
.nf
void ScrolledListHighlightItem(w,item_index)
Widget w;
int item_index;
.fi
.sp
.RS 5
This routine highlights the item with index number <item_index>.
.RE
.sp
.nf
ScrolledListReturnStruct *ScrolledListGetHighlighted(sw)
ScrolledListWidget sw;
.fi
.sp
.RS 5
This routine returns the current highlighted items info.
.RE
.sp
.nf
int ScrolledListToggleItem(plw,item_index)
ScrolledListWidget plw;
.fi
.sp
.RS 5
This routine highlights the item with index <item_index> if it is
unhighlighted and unhighlights it if it is already highlighted.  The
action performed by the toggle is returned (ScrolledList_ACTION_HIGHLIGHT
or ScrolledList_ACTION_UNHIGHLIGHT).
.RE
.sp
.nf
Boolean ScrolledListIsHighlighted(w,item_index)
Widget w;
int item_index;
.fi
.sp
.RS 5
This routine returns a boolean that indicates if the item with index
<item_index> was highlighted or not.
.RE
.sp
.nf
Boolean ScrolledListGetItem(w,item_index,str_ptr,high_ptr,sens_ptr)
Widget w;
int item_index;
String *str_ptr;
Boolean *high_ptr,*sens_ptr;
.fi
.sp
.RS 5
This routine returns information about a numbered item including the
name of the item, whether it is highlighted, and its sensitivity.  If
the item index number does not correspond to an item, False is
returned, else True is returned.
.RE
.sp
.nf
.ne 4
.SH RESTRICTIONS
.LP
For no good reason this widget is hard coded to only allow one item to
be selected at a time.  This is just a simple wrapper of a Viewport
around a MultiList.  Most of the work is performed by the MultiList
widget.  If you want different features, you may want to deal with the
MultiList widget directly.
.SH AUTHOR
.sp
.nf
Brian Totty, \fItotty@cs.uiuc.edu\fR
Department of Computer Science,
University of Illinois at Urbana-Champaign
1304 W. Springfield Avenue
Urbana, IL 61801
.fi
