#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xfwf/Board.h>
#include <Xfwf/Label.h>
#include <Xfwf/Tabs.h>

static String fallback_resources[] = {
    "*board.location:		0 0 600 250",
    /* "*highlightThickness:	0", */
    "*tabs.location:		10 10 1.0-20 33",
    "*tabs.background:		gray80",
    "*tabs.font:		*-helvetica-bold-r-*-140-*",
    "*label.location:		10 42 1.0-22 1.0-56",
    "*label.borderWidth:	1",
    "*label.background:		gray80",
    NULL,
};

static Widget toplevel, board, label, tabs;
static XtAppContext app_context;

static String texts[] = {
    "This is a test for the XfwfTabs widget.\n\
Click on any of the tabs to display the\n\
corresponding text.",
    "A click on a tab results in a callback\n\
that is used by the test program to\n\
change the text in this label\n\
and to change the number of tabs.",
    "This is just filler text.",
    "The last tab on the right is the\n\
`Quit' button. The test program will\n\
exit when you click that one.",
    "This is more filler text",
    "The XfwfTabs widget overlaps\n\
a few pixels of the label widget,\n\
so that the top border of the label is\n\
hidden and the tabs seem to be attached\n\
to the text.",
    "This won't get displayed",
};

static String labels[] = {
    "Introduction",
    "Clicks",
    "Just filler",
    "About the `Quit' tab",
    "More filler",
    "Pixel trick",
    "Quit",
};

static int cur = 0;				/* Current label/text */


/* ARGSUSED */
static void handle_click(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    int tab = (int) call_data;

    if (tab == 0) return;
    cur += tab;

    if (cur == XtNumber(labels) - 1) exit(0);	/* Quit button? */

    /* Change tabs */
    XtVaSetValues(tabs, 
		  XtNlefttabs, cur,
		  XtNrighttabs, XtNumber(labels) - cur - 1,
		  NULL);
    /* Change text */
    XtVaSetValues(label, XtNlabel, texts[cur], NULL);
}


void main(argc, argv)
    int argc;
    String *argv;
{
    toplevel = XtVaAppInitialize(&app_context, argv[0], NULL, 0,
				  &argc, argv, fallback_resources, NULL);
    board = XtVaCreateManagedWidget
	("board", xfwfBoardWidgetClass, toplevel, NULL);
    tabs = XtVaCreateManagedWidget
	("tabs", xfwfTabsWidgetClass, board,
	 XtNlabels, labels,
	 XtNlefttabs, cur,
	 XtNrighttabs, XtNumber(labels) - 1 - cur,
	 NULL);
    label = XtVaCreateManagedWidget
	("label", xfwfLabelWidgetClass, board,
	 XtNlabel, texts[cur],
	 NULL);
    XtRealizeWidget(toplevel);
    XtAddCallback(tabs, XtNactivate, handle_click, NULL);
    XtAppMainLoop(app_context);
}
