#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xfwf/TextMenu.h>
#include <Xfwf/Button.h>
#include <Xfwf/Board.h>

static String fallback_resources[] = {
    "TextMenuT.board.width: 240",
    "TextMenuT.board.height: 50",

    "*button1.label: Press here",
    "*button1.location: 10 10 110 30",

    "*button2.label: Press here",
    "*button2.location: 120 10 110 30",

    "*menu1.menu: \
_Zeroth item\\n\
Firs_t item\\n\
_Second item\\n\
_Third item\\n\
-----------\\n\
E_xit",
    "*menu1.active: 27",			/* 11011 = `Second' inactive */

    "*menu2.menu: \
_Zeroth item\\n\
_First item\\n\
Se_cond item\\n\
_Third item\\n\
-----------\\n\
E_xit",
    "*menu2.active: 30",			/* 11110 = `Zeroth' inactive */

    NULL,
};

static Widget toplevel, menu1, menu2, button1, button2, board;
static XtAppContext app_context;

/*
 * activate is attached the activate callback of both menus
 */

/* ARGSUSED */
static void activate(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    XfwfTextMenuData *data = (XfwfTextMenuData*) call_data;

    printf("You selected %u (\"%s\")\n", data->n, data->label);
    if (data->n == 4) exit(0);
}


/*
 * change is attached to the changeSelection callback of both menus
 */

/* ARGSUSED */
static void change(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    switch (((XfwfTextMenuData*) call_data)->n) {
    case -1: printf("  Outside menu\n"); break;
    case  0: printf("  The zeroth item doesn't do anything\r"); break;
    case  1: printf("  The first item is unassigned\n"); break;
    case  2: printf("  The second item is inactive\n"); break;
    case  3: printf("  The third item does nothing\n"); break;
    case  4: printf("  This item stops the program\n"); break;
    }
}


/* ARGSUSED */
static void place_menu(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    XButtonEvent *b = (XButtonEvent *) event;

    /* Open the menu with the mouse 10 pixels inside */
    if (params[0][4] == '1')			/* "menu1" */
	XtVaSetValues(menu1, XtNx, b->x_root - 10, XtNy, b->y_root - 10, NULL);
    else					/* "menu2" */
	XtVaSetValues(menu2, XtNx, b->x_root - 10, XtNy, b->y_root - 10, NULL);
}


static char trans1[] = "<BtnDown>: place_menu(menu1) XtMenuPopup(menu1)";
static char trans2[] = "<BtnDown>: place_menu(menu2) XtMenuPopup(menu2)";

static XtActionsRec actions[] = {{"place_menu", place_menu}};


void main(argc, argv)
    int argc;
    String *argv;
{
    printf("Keyboard traversal is not working.\n");
    printf("Use pulldown buttons instead of normal buttons for that.\n");

    toplevel = XtVaAppInitialize
	(&app_context, "TextMenuT", NULL, 0, &argc, argv,
	 fallback_resources, NULL);

    XtAppAddActions(app_context, actions, XtNumber(actions));

    board = XtVaCreateManagedWidget
	("board", xfwfBoardWidgetClass, toplevel, NULL);
    menu1 = XtCreatePopupShell
	("menu1", xfwfTextMenuWidgetClass, toplevel, NULL, 0);
    menu2 = XtCreatePopupShell
	("menu2", xfwfTextMenuWidgetClass, toplevel, NULL, 0);
    button1 = XtVaCreateManagedWidget
	("button1", xfwfButtonWidgetClass, board, 
	 XtVaTypedArg, XtNtranslations, XtRString, trans1, sizeof(trans1),
	 NULL);
    button2 = XtVaCreateManagedWidget
	("button2", xfwfButtonWidgetClass, board,
	 XtVaTypedArg, XtNtranslations, XtRString, trans2, sizeof(trans2),
	 NULL);

    XtAddCallback(menu1, XtNactivate, activate, NULL);
    XtAddCallback(menu1, XtNchangeSelection, change, NULL);
    XtAddCallback(menu2, XtNactivate, activate, NULL);
    XtAddCallback(menu2, XtNchangeSelection, change, NULL);

    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_context);
}
