/*							-*-indented-text-*-
**  File: scan.l
**  Date: 28 Apr 1992
**  Author: Bert Bos <bert@let.rug.nl>
**  Description: (F)LEX definition for Widget Builder
**  $Header: scan.l,v 2.2 94/01/31 21:00:33 bert Exp $
*/

%k 2000

%{
#include "types.c"
#include "y.tab.h"
#include <string.h>
#ifdef USE_VARARGS
#include <varargs.h>
#else
#include <stdarg.h>
#endif
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "util.e"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern void err P_((Boolean fatal, char *format,...));

int lineno;
extern char *filename;

static int countlines(s)
  char *s;
{
  int n = 0;
  for (; *s; s++)
    if (*s == '\n') n++;
  return n;
}

static void set_line(s)
  char *s;
{
  static char buf[1024];
  int n;

  while (! isdigit(*s)) s++;
  n = sscanf(s, "%d \"%s\"", &lineno, buf);
  if (n == 2) filename = buf;
}

static Boolean get_body P_((void));

#undef yywrap

%}

a		[aA]
b		[bB]
c		[cC]
d		[dD]
e		[eE]
f		[fF]
g		[gG]
h		[hH]
i		[iI]
j		[jJ]
k		[kK]
l		[lL]
m		[mM]
n		[nN]
o		[oO]
p		[pP]
q		[qQ]
r		[rR]
s		[sS]
t		[tT]
u		[uU]
v		[vV]
w		[wW]
x		[xX]
y		[yY]
z		[zZ]

class		@{c}{l}{a}{s}{s}
classvars	@{c}{l}{a}{s}{s}{v}{a}{r}{s}
public		@{p}{u}{b}{l}{i}{c}
private		@{p}{r}{i}{v}{a}{t}{e}
methods		@{m}{e}{t}{h}{o}{d}{s}
actions		@{a}{c}{t}{i}{o}{n}{s}
translations	@{t}{r}{a}{n}{s}{l}{a}{t}{i}{o}{n}{s}
imports		@{i}{m}{p}{o}{r}{t}{s}
exports		@{e}{x}{p}{o}{r}{t}{s}
utilities	@{u}{t}{i}{l}{i}{t}{i}{e}{s}
proc		@{p}{r}{o}{c}
var		@{v}{a}{r}
def		@{d}{e}{f}
type		@{t}{y}{p}{e}
incl		@{i}{n}{c}{l}
trans		@{t}{r}{a}{n}{s}
nocode		@{n}{o}{c}{o}{d}{e}	
nodoc		@{n}{o}{d}{o}{c}
guard		@{g}{u}{a}{r}{d}
guardp		@{g}{u}{a}{r}{d}{p}
file		@{f}{i}{l}{e}
linedir		(^#[ \t]*line[ \t]+[0-9]+.*\n|^#[ \t]+[0-9]+.*\n)

%%

{class}			{ yylval.i = lineno; return CLASS; }
{classvars}		{ yylval.i = lineno; return CLASSVARS; }
{public}		{ yylval.i = lineno; return PUBLIC; }
{private}		{ yylval.i = lineno; return PRIVATE; }
{methods}		{ yylval.i = lineno; return METHODS; }
{actions}		{ yylval.i = lineno; return ACTIONS; }
{translations}		{ yylval.i = lineno; return TRANSLATIONS; }
{imports}		{ yylval.i = lineno; return IMPORTS; }
{exports}		{ yylval.i = lineno; return EXPORTS; }
{utilities}		{ yylval.i = lineno; return UTILITIES; }
{proc}			{ yylval.i = lineno; return PROC; }
{var}			{ yylval.i = lineno; return VAR; }
{def}			{ yylval.i = lineno; return DEF; }
{type}			{ yylval.i = lineno; return TYPE; }
{incl}			{ yylval.i = lineno; return INCL; }
{trans}			{ yylval.i = lineno; return TRANS; }
{nocode}		{ return NOCODE; }
{nodoc}			{ return NODOC; }
{guard}			{ return GUARD; }
{guardp}		{ return GUARDP; }
{file}			{ return FILE_OPT; }
@[A-Za-z0-9_-]+		{ return UNKNOWN; }
@[ \t\n]([^@]|@@)*	{ lineno += countlines((char*)yytext); yylval.string
			  = hash((char*)yytext+2); return TEXT; }
{linedir}		{ set_line(yytext); }
^#.*$			{ /* ignore */ }
[ \t]*			{ /* ignore */ }
\n			{ lineno++; }
[A-Za-z_][A-Za-z0-9_.]*	{ yylval.string = hash((char*)yytext); return IDENT; }
"$"			{ return DOLLAR; }
[0-9]+			|
[0-9]*\.[0-9]+		|
0x[0-9A-F]+		{ yylval.string = hash((char*)yytext); return NUMBER; }
"/*"([^*]|"*"[^/])*"*/"	{ yylval.string = hash((char*)yytext); lineno +=
			  countlines((char*)yytext); return COMMENT; }
"<"[^ \t\n<>()]+">"	{ char c; c = yytext[yyleng-1]; yytext[yyleng-1]
			  = '\0'; yylval.string = hash((char*)yytext + 1);
			  yytext[yyleng-1] = c; return BRACKETED; }
"("			{ return LPAR; }
")"			{ return RPAR; }
"["			{ return LBRACK; }
"]"			{ return RBRACK; }
";"			{ return SEMI; }
"+"			{ return PLUS; }
"="			{ return EQUALS; }
"*"			{ return STAR; }
"!"			{ return EXCLAM; }
"~"			{ return TILDE; }
","			{ return COMMA; }
":"			{ return COLON; }
"/"			{ return SLASH; }
"&"			|
"?"			|
">"			|
"<"			|
"-"			|
"|"			|
"%"			|
"^"			|
"."			|
\'[^']{1,4}\'		{ yylval.string = hash((char*)yytext); return CTOK; }
\"([^"]|\\\")*\"	{ lineno += countlines((char*)yytext); yylval.string =
			  hash((char*)yytext); return CSTRING; }
"{"			{ if (get_body()) return BODY; else return ILL_BODY; }

.			{ return ILL_CHAR; }



%%

  /* this routine is called when a left brace has been seen */
static Boolean get_body()
{
#define BUFSTEP 500
    int braces = 1, i = 0, len;
    Boolean quote = False, comment = False;
    char c, prev = '{';
    char *buf;
  
    len = BUFSTEP;
    buf = malloc(len * sizeof(char));
    buf[0] = '{';
    i = 1;
    while (braces != 0 && (c = input()) != EOF) {
	if (i >= len) {
	    len += BUFSTEP;
	    buf = realloc(buf, len * sizeof(char));
	    if (! buf) { fprintf(stderr, "Out of memory\n"); exit(1); }
	}
	buf[i] = c;
	i++;
	switch (c) {
	case '{':
	    if (!quote && !comment) braces++;
	    break;
	case '}':
	    if (!quote && !comment) braces--;
	    break;
	case '"':
	    if (!comment && prev != '\\') quote = !quote;
	    break;
	case '*':
	    if (!quote && !comment && prev == '/') comment = True;
	    break;
	case '/':
	    if (comment && prev == '*') comment = False;
	    break;
	case '\n':
	    if (quote && prev != '\\') {
		err(False, "missing quote (\")\n");
		quote = False;
	    }
	    lineno++;
	    break;
	}
	prev = prev == '\\' ? '\0' : c;
    }
    if (braces != 0) return False;
    if (i >= len) {
	len += BUFSTEP;
	buf = realloc(buf, len * sizeof(char));
    }
    buf[i] = '\0';
    yylval.string = hash(buf);
    free(buf);
    return True;
}

