/*1:*/
#line 43 "util.web"

/*2:*/
#line 52 "util.web"

#include<stdio.h>
#ifdef USE_VARARGS
#include<varargs.h>
#else
#include<stdarg.h>
#endif
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include<assert.h>
#include"types.c"
#include"debug.e"

/*:2*/
#line 44 "util.web"

/*3:*/
#line 71 "util.web"

#line 72 "util.web"
Class classes= NULL;

/*:3*//*8:*/
#line 160 "util.web"

struct _STRING{
char *s;
int linkcount;
STRING next;
};
STRING hashtable[8009];
int r2[8009],r1[8009];
int nused= 0;

/*:8*//*38:*/
#line 721 "util.web"

#line 722 "util.web"
Class toplevel= NULL;

/*:38*/
#line 45 "util.web"

/*7:*/
#line 125 "util.web"

char *Strdup(s)
char *s;
{
char *t;
if(s)t= strdup(s);else t= strdup("");
if(t==NULL){
(void)fprintf(stderr,"out of memory\n");
exit(1);
}
return t;
}

void *Malloc(size)
size_t size;
{
void *t;
t= malloc(size);
if(t==NULL){
(void)fprintf(stderr,"out of memory\n");
exit(1);
}
return t;
}

/*:7*//*9:*/
#line 174 "util.web"

static int hashval(name)
char *name;
{
char *p;
unsigned int h= 0,g,n= 20;
if(name==NULL)return 0;
for(p= name;n&& *p;p++,n--){
h= (h<<4)+( *p);
if(g= h&0xf0000000){
h= h^(g>>24);
h= h^g;
}
}
return h%8009;
}

/*:9*//*11:*/
#line 207 "util.web"

STRING hash(s)
char *s;
{
int h;STRING t;
if(s==NULL||s[0]=='\0')return((STRING)NULL);
h= hashval(s);
if(!(0<=r2[h]&&r2[h]<nused&&r1[r2[h]]==h)){
t= Malloc(sizeof( *(t)));
t->s= Strdup(s);
t->linkcount= 1;
t->next= ((STRING)NULL);
do{r2[h]= nused;r1[nused]= h;nused++;}while(0);
hashtable[h]= t;
return t;
}
for(t= hashtable[h];t;t= t->next){
if(strcmp(t->s,s)==0){
t->linkcount++;
return t;
}
}
t= Malloc(sizeof( *(t)));
t->s= Strdup(s);
t->linkcount= 1;
t->next= hashtable[h];
hashtable[h]= t;
return t;
}

/*:11*//*12:*/
#line 245 "util.web"

void delete(s)
STRING s;
{
#ifdef NDEBUG
int h;STRING t;
#endif
if(s==((STRING)NULL))return;
s->linkcount--;
if(s->linkcount>0)return;
#ifdef NDEBUG
h= hashval(s->s);
if(hashtable[h]==s)
hashtable[h]= s->next;
else{
for(t= hashtable[h];t->next!=s;t= t->next);
t->next= s->next;
}
if(s->s)(void)free(s->s);
(void)free(s);
#else
if(s->linkcount<0)
debug("linkcount on %s is %d\n",s->s,s->linkcount);
#endif
}

/*:12*//*13:*/
#line 274 "util.web"

#line 275 "util.web"
char *get(s)
STRING s;
{
if(s==((STRING)NULL))
return"";
else
return s->s;
}

/*:13*//*14:*/
#line 286 "util.web"

#line 287 "util.web"
STRING hdup(s)
STRING s;
{
if(s==((STRING)NULL))return((STRING)NULL);
s->linkcount++;
return s;
}

/*:14*//*15:*/
#line 298 "util.web"

#line 299 "util.web"

#ifdef USE_VARARGS
STRING catstr(va_alist)va_dcl
#else
#ifdef __STDC__
STRING catstr(int n,...)
#else
STRING catstr(n)int n;
#endif
#endif
{
va_list ap;
#ifdef USE_VARARGS
int n;
#endif
unsigned int len= 0;
char *s, *s1;
STRING t;
int i;

#ifdef USE_VARARGS
va_start(ap);
n= va_arg(ap,int);
#else
va_start(ap,n);
#endif
if(n==0){
va_end(ap);
return((STRING)NULL);
}else{
for(i= n;i>0;i--){
s1= va_arg(ap,char *);
len+= s1?strlen(s1):0;
}
va_end(ap);
s= Malloc((len+2) *sizeof(char));
s[0]= '\0';
#ifdef USE_VARARGS
va_start(ap);
n= va_arg(ap,int);
#else
va_start(ap,n);
#endif
for(i= n;i>0;i--){
s1= va_arg(ap,char *);
if(s1)(void)strcat(s,s1);
}
va_end(ap);
t= hash(s);
return t;
}
}

/*:15*//*16:*/
#line 355 "util.web"

#line 356 "util.web"
size_t Strlen(s)
STRING s;
{
return s?(s->s?strlen(s->s):0):0;
}

/*:16*/
#line 46 "util.web"

/*17:*/
#line 367 "util.web"

#line 368 "util.web"
STRING get_classname(s)
STRING s;
{
char *h, *h1;
STRING t;
h= h1= Strdup(s->s);
if( *h=='$')h++;
if('a'<=h[0]&&h[0]<='z')h[0]+= 'A'-'a';
if(h[0]=='X'&&'a'<=h[1]&&h[1]<='z')h[1]+= 'A'-'a';
t= hash(h);free(h1);
return t;
}

/*:17*//*18:*/
#line 386 "util.web"

#line 387 "util.web"
STRING get_instname(s)
STRING s;
{
char *h, *h1;
STRING t;
h= h1= Strdup(s->s);
if( *h=='$')h++;
if('A'<=h[0]&&h[0]<='Z')h[0]+= 'a'-'A';
if(h[0]=='x'&&'A'<=h[1]&&h[1]<='Z')h[1]+= 'a'-'A';
t= hash(h);free(h1);
return t;
}

/*:18*//*19:*/
#line 403 "util.web"

#line 404 "util.web"
STRING get_word(s)
char *s;
{
char *word;
STRING t;
int i;
if(s==NULL)
return((STRING)NULL);
else{
word= Malloc(sizeof(char) *strlen(s)+1);
for(i= 0;isalnum(s[i])||s[i]=='_';i++)
word[i]= s[i];
word[i]= '\0';
t= hash(word);
free(word);
return t;
}
}

/*:19*/
#line 47 "util.web"

/*4:*/
#line 78 "util.web"

#line 79 "util.web"
void add_class(c)
Class c;
{
assert(c->next==NULL);
c->next= classes;
classes= c;
}

/*:4*//*5:*/
#line 93 "util.web"

#line 94 "util.web"
Boolean get_option(value,c,name)
STRING *value;
Class c;
STRING name;
{
Option h;
h= c->options;
while(h!=NULL&&h->opt!=name)
h= h->next;
if(h!=NULL){
 *value= h->val;
return True;
}else{
return False;
}
}

/*:5*//*20:*/
#line 425 "util.web"

#line 426 "util.web"
STRING get_guard(c)
Class c;
{
STRING guard;
if(!get_option(&guard,c,hash("guard")))
guard= catstr(3,"_",get(c->name),"_H_");
return guard;
}

/*:20*//*21:*/
#line 437 "util.web"

#line 438 "util.web"
STRING get_guardP(c)
Class c;
{
STRING guard;
if(!get_option(&guard,c,hash("guardP")))
guard= catstr(3,"_",get(c->name),"P_H_");
return guard;
}

/*:21*//*22:*/
#line 453 "util.web"

#line 454 "util.web"
STRING get_headername(dir,c)
char *dir;
Class c;
{
STRING t;
static STRING file= ((STRING)NULL);
char *s;
if(file==((STRING)NULL))file= hash("file");
s= Malloc((dir?strlen(dir):0)+16);
/*23:*/
#line 471 "util.web"

#line 472 "util.web"
if(dir!=NULL&&dir[0]!='\0'){
(void)strcpy(s,dir);
if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
}

/*:23*/
#line 463 "util.web"

if(!get_option(&t,c,file))t= c->name;
(void)strncat(s,get(t),10);
(void)strcat(s,".h");
t= hash(s);free(s);
return t;
}

/*:22*//*24:*/
#line 482 "util.web"

#line 483 "util.web"
STRING get_headerPname(dir,c)
char *dir;
Class c;
{
char *s;
static STRING file= ((STRING)NULL);
STRING t;
if(file==((STRING)NULL))file= hash("file");
s= Malloc((dir?strlen(dir):0)+16);
/*23:*/
#line 471 "util.web"

#line 472 "util.web"
if(dir!=NULL&&dir[0]!='\0'){
(void)strcpy(s,dir);
if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
}

/*:23*/
#line 492 "util.web"

if(!get_option(&t,c,file))t= c->name;
(void)strncat(s,get(t),9);
(void)strcat(s,"P.h");
t= hash(s);free(s);
return t;
}

/*:24*//*25:*/
#line 505 "util.web"

#line 506 "util.web"
STRING get_implementationname(dir,c)
char *dir;
Class c;
{
char *s;
static STRING file= ((STRING)NULL);
STRING t;
if(file==((STRING)NULL))file= hash("file");
s= Malloc((dir?strlen(dir):0)+16);
/*23:*/
#line 471 "util.web"

#line 472 "util.web"
if(dir!=NULL&&dir[0]!='\0'){
(void)strcpy(s,dir);
if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
}

/*:23*/
#line 515 "util.web"

if(!get_option(&t,c,file))t= c->name;
(void)strncat(s,get(t),10);
(void)strcat(s,".c");
t= hash(s);free(s);
return t;
}

/*:25*//*26:*/
#line 526 "util.web"

#line 527 "util.web"
STRING get_docfilename(dir,c)
char *dir;
Class c;
{
char *s;
static STRING file= ((STRING)NULL);
STRING t;
if(file==((STRING)NULL))file= hash("file");
s= Malloc((dir?strlen(dir):0)+16);
/*23:*/
#line 471 "util.web"

#line 472 "util.web"
if(dir!=NULL&&dir[0]!='\0'){
(void)strcpy(s,dir);
if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
}

/*:23*/
#line 536 "util.web"

if(!get_option(&t,c,file))t= c->name;
(void)strncat(s,get(t),8);
(void)strcat(s,".doc");
t= hash(s);free(s);
return t;
}

/*:26*//*28:*/
#line 549 "util.web"

#line 550 "util.web"
static Class find_class(name)
STRING name;
{
Class h;
h= classes;
while(h&&h->name!=name)
h= h->next;
return h;
}

/*:28*//*29:*/
#line 563 "util.web"

#line 564 "util.web"
Class find_superclass(c,name)
Class c;
STRING name;
{
if(c==NULL)return NULL;
else if(c->name==name)return c;
else return find_superclass(c->super);
}

/*:29*//*33:*/
#line 628 "util.web"

#line 629 "util.web"
Section find_method(c,m)
Class c;
STRING m;
{
Section d,h;
if(c==NULL)return NULL;
if((h= find_method(c->super,m)))
return h;
for(d= c->methods;d;d= d->next)
if(d->decl&&d->decl->tp==Proc&&d->decl->name==m)return d;
return NULL;
}

/*:33*//*34:*/
#line 646 "util.web"

#line 647 "util.web"
Boolean has_method(c,m)
Class c;
STRING m;
{
Section d;
for(d= c->methods;d;d= d->next)
if(d->decl&&d->decl->tp==Proc&&d->decl->name==m)return True;
return False;
}

/*:34*//*35:*/
#line 660 "util.web"

#line 661 "util.web"
Section find_pubvar(c,m)
Class c;
STRING m;
{
Section d,h;
if(c==NULL)return NULL;
if((h= find_pubvar(c->super,m)))
return h;
for(d= c->publicvars;d;d= d->next)
if(d->decl&&d->decl->tp==Var&&d->decl->name==m)return d;
return NULL;
}

/*:35*//*36:*/
#line 677 "util.web"

#line 678 "util.web"
STRING find_classvar_value(c,name)
Class c;
STRING name;
{
Section d;
for(d= c->classvars;d;d= d->next)
if(d->decl&&d->decl->tp==Var&&d->decl->name==name)
return d->decl->value;
if(c->super!=NULL)
return find_classvar_value(c->super,name);
else
return NULL;
}

/*:36*//*37:*/
#line 695 "util.web"

#line 696 "util.web"
STRING find_instvar_value(c,name)
Class c;
STRING name;
{
Section d;
for(d= c->publicvars;d;d= d->next)
if(d->decl&&d->decl->tp==Var&&d->decl->name==name)
return d->decl->value;
for(d= c->privatevars;d;d= d->next)
if(d->decl&&d->decl->tp==Var&&d->decl->name==name)
return d->decl->value;
if(c->super!=NULL)
return find_instvar_value(c->super,name);
else
return NULL;
}

/*:37*//*39:*/
#line 729 "util.web"

#line 730 "util.web"
void set_hierarchy()
{
Class c;
char *p;
for(c= classes;c;c= c->next){
if((p= strrchr(get(c->superclass),'/')))
c->super= find_class(hash(p+1));
else
c->super= find_class(c->superclass);
if(c->super==NULL){
c->sister= toplevel;
toplevel= c;
}else{
c->sister= c->super->daughters;
c->super->daughters= c;
}
}
}

/*:39*/
#line 48 "util.web"

/*30:*/
#line 579 "util.web"

#line 580 "util.web"
Class find_classvar_class(c,name)
Class c;
STRING name;
{
Class h;
Section d;
if(c==NULL)return NULL;
if((h= find_classvar_class(c->super,name)))
return h;
for(d= c->classvars;d;d= d->next)
if(d->decl&&d->decl->tp==Var&&d->decl->name==name)return c;
return NULL;
}

/*:30*//*31:*/
#line 594 "util.web"

#line 595 "util.web"
Class find_instvar_class(c,name)
Class c;
STRING name;
{
Class h;
Section d;
if(c==NULL)return NULL;
if((h= find_instvar_class(c->super,name)))return h;
for(d= c->publicvars;d;d= d->next)
if(d->decl&&d->decl->tp==Var&&d->decl->name==name)return c;
for(d= c->privatevars;d;d= d->next)
if(d->decl&&d->decl->tp==Var&&d->decl->name==name)return c;
return NULL;
}

/*:31*//*32:*/
#line 610 "util.web"

#line 611 "util.web"
Class find_method_class(c,name)
Class c;
STRING name;
{
Class h;
Section d;
if(c==NULL)return NULL;
if((h= find_method_class(c->super,name)))
return h;
for(d= c->methods;d;d= d->next)
if(d->decl&&d->decl->tp==Proc&&d->decl->name==name)return c;
return NULL;
}

/*:32*/
#line 49 "util.web"

/*40:*/
#line 751 "util.web"

#line 752 "util.web"
Boolean strneq(a,b,n)
char *a, *b;
int n;
{
if(a==NULL)return b==NULL|| *b=='\0';
if(b==NULL)return False;
while(n!=0&& *a&& *a== *b){
a++;
b++;
n--;
}
return n==0|| *a== *b;
}

/*:40*/
#line 50 "util.web"


/*:1*/
