#!/bin/sh
# Compile programs, treating .c files as C++.

[ -n "$TRACE" ] && set -x

# The compiler name might be different when doing cross-compilation
# (this should be configured)
#
gcc_name=gcc

# replace the command name by the name of the new command
#
progname=`basename $0`
path=`echo $0 | sed -e "s;${progname};;"`
gcc="${path}$gcc_name"

newargs=
quote=no
library=-lg++

for arg in "$@"
do
  if [ $quote = yes ]
  then
    newargs="$newargs '$arg'"
    quote=no
  else
    quote=no
    case $arg in
      -nostdlib)
	# Inhibit linking with -lg++.
        newargs="$newargs '$arg'"
	library=
	;;
      -[bBVDUoeTuIYmLiA] | -Tdata)
        newargs="$newargs '$arg'"
	# these switches take following word as argument,
	# so don't treat it as a file name.
	quote=yes
	;;
      -[cSE]|-M|-MM)
	# Don't specify libraries if we won't link,
	# since that would cause a warning.
        newargs="$newargs '$arg'"
	library=
	;;
      -xnone)
        newargs="$newargs '$arg'"
	speclang=
	;;
      -x*)
        newargs="$newargs '$arg'"
	speclang=yes
	;;
      -v)
	newargs="$newargs '$arg'"
	# catch `c++ -v'
	if [ $# = 1 ] ; then library="" ; fi
	;;
      *)
	# If file ends in .c or .i, put options around it.
	# But not if a specified -x option is currently active.
	temp=`expr $arg : '.*\.[ci]$'`
	if [ \( x$temp != x0 \) -a \( x$speclang = x \) ]
	then
	  newargs="$newargs -xc++ '$arg' -xnone"
	else
	  newargs="$newargs '$arg'"
	fi
	;;
    esac
  fi
done

eval $gcc $newargs $library
