/* Definitions of target machine for GNU compiler.
   Motorola m88100 running M88K BCS.
   Copyright (C) 1988-1990 Free Software Foundation, Inc.
   Contributed by Michael Tiemann (tiemann@cygnus.com)
   Enhanced by Michael Meissner (meissner@osf.org)
   Improved by Tom Wood (wood@dg-rtp.dg.com)
   Currently supported by Steve Chamberlain (steve@cygnus.com)

   This is not an official release from FSF.  (The integration of
   these changes is expected to occur in version 2.0.)

   Please report bugs to bugs@cygnus.com, not to the mailing lists.


This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "m88k.h"

/* Identify the compiler.  */
#undef  VERSION_INFO
#define VERSION_INFO "88open OCS/BCS, Cygnus Support "

/* Default switches */
#undef	TARGET_DEFAULT
#define TARGET_DEFAULT	(MASK_CHECK_ZERO_DIV	 | \
			 MASK_OCS_FRAME_POSITION)

/* Macros to be automatically defined.  */
#undef	CPP_PREDEFINES
#define CPP_PREDEFINES "-Dm88000 -Dm88k -DBCS -DM88K_BCS -D_M88KBCS_SOURE -D__targetting_M88KBCS -D__using_M88KBCS"


/* Assembler support (-V, silicon filter, legends for mxdb).  */
#undef	ASM_SPEC
#define ASM_SPEC "\
%{V} %{v:%{!V:-V}} %{pipe: - }\
%{mlegend:-Wc,-fix-bb,-h\"gcc-1.91.9\",-s\"%i\"\
%{traditional:,-lc}%{!traditional:,-lansi-c}\
%{mkeep-coff:,-keep-coff}\
%{mocs-frame-position:,-ocs}\
%{mexternal-legend:,-external}}"

#undef CC1PLUS_SPEC
#define CC1PLUS_SPEC "%{!nostabs:-fno-gnu-binutils}"

/* Linker and library spec's.
   -static, -shared, -symbolic, -h* and -z* access AT&T V.4 link options.
   -svr4 instructs gcc to place /usr/lib/values-X[cat].o on link the line.
   When the -G link option is used (-shared and -symbolic) a final link is
   not being done.  */
#undef	LIB_SPEC
#define LIB_SPEC "%{!shared:%{!symbolic:-lc}}"
#undef	LINK_SPEC
#define LINK_SPEC "%{z*} %{h*} %{V} %{v:%{!V:-V}} \
		   %{static:-dn -Bstatic} \
		   %{shared:-G -dy} \
		   %{symbolic:-Bsymbolic -G -dy} \
		   %{pg:-L/usr/lib/libp}%{p:-L/usr/lib/libp}"
#undef	STARTFILE_SPEC
#define STARTFILE_SPEC "%{!shared:%{!symbolic:%{pg:gcrt0.o%s} \
			 %{!pg:%{p:/lib/mcrt0.o}%{!p:/lib/crt0.o}} \
			 %{svr4:%{ansi:/lib/values-Xc.o} \
			  %{!ansi:%{traditional:/lib/values-Xt.o} \
			   %{!traditional:/usr/lib/values-Xa.o}}}}}"



/* DGUX V.4 isn't quite ELF.  */
#undef  VERSION_0300_SYNTAX
#define VERSION_0300_SYNTAX (0)

/* Output the legend info for mxdb.  */
#undef  ASM_FIRST_LINE
#define ASM_FIRST_LINE(FILE)						\
  fprintf (FILE, ";legend_info -fix-bb -h\"gcc-1.91.9\" -s\"%s\" %s\n", main_input_filename,			\
	       (flag_traditional ? "-lc" : "-lansi-c"));		\

#define CXXRT0 "/usr/local/lib/c++rt0.o"

