/* 
FUNCTION
	<<fpgetmask>>, <<fpsetmask>>---IEEE floating-point exception mask

INDEX
fpgetmask
INDEX
fpsetmask

ANSI_SYNOPSIS
	#include <ieeefp.h>
	fp_except fpgetmask(void);
	fp_except fpsetmask(fp_except <[mask]>);

TRAD_SYNOPSIS
	#include <ieeefp.h>
	fp_except fpgetmask();
	fp_except fpsetmask(<[mask]>)
	fp_except <[mask]>;

DESCRIPTION
For each of five possible errors during IEEE floating-point calculations,
you can choose whether the processor should activate a trap
immediately.  (A flag recording the error is set in any case; see
<<fpgetsticky>>).  Call <<fpsetmask>> to specify the exceptions for
which you wish to activate traps, using sums of these values (defined
in `<<ieeefp.h>>') for the <[mask]> argument:
o+
o FP_X_INV
invalid operation

o FP_X_DZ
division by zero

o FP_X_OFL
overflow (number too large to represent)

o FP_X_UFL
underflow (number too small to represent)

o FP_X_IMP
loss of precision
o-
Use <<fpgetmask>> to find out the exception mask value currently in
effect.

Before you resume execution after a trap, use <<fpsetsticky>> to clear
the flag corresponding to the exception you've handled; otherwise the
next trap may not reflect the proper error.

RETURNS
<<fpgetmask>> returns the current exception mask;
<<fpsetmask>> returns the value of the exception mask prior to setting
it to <[mask]>.

PORTABILITY
These functions are not ANSI C.
*/
