/* 
FUNCTION
	<<fpgetround>>, <<fpsetround>>, <<fpgetroundtoi>>, <<fpsetroundtoi>>---IEEE floating-point rounding

INDEX
fpgetround
INDEX
fpsetround
INDEX
fpgetroundtoi
INDEX
fpsetroundtoi

ANSI_SYNOPSIS
	#include <ieeefp.h>
	fp_rnd fpgetround(void);
	fp_rnd fpsetround(fp_rnd <[direction]>);
	fp_rnd fpgetroundtoi(void);
	fp_rnd fpsetroundtoi(fp_rnd <[flag]>);

TRAD_SYNOPSIS
	#include <ieeefp.h>
	fp_rnd fpgetround();
	fp_rnd fpsetround(<[direction]>)
	fp_rnd <[direction]>;
	fp_rnd fpgetroundtoi();
	fp_rnd fpsetroundtoi(<[flag]>)
	fp_rnd <[flag]>;

DESCRIPTION
Use <<fpsetround>> to control the direction of rounding in IEEE
floating-point calculations, and <<fpgetround>> to discover the
direction of rounding currently in use.  The values for <[direction]>
are encoded as one of the following (defined in `<<ieeefp.h>>'):
o+
o FP_RN
round to the nearest number; round to even numbers if two numbers are
equally near
o FP_RM
round down (towards negative infinity)
o FP_RP
round up (towards positive infinity)
o FP_RZ
truncate rather than rounding (toward zero)
o-

Rounding on coercion to integer types can either follow the general
rounding direction, or it can independently always truncate the
number.  Use <<fpgetroundtoi>> to discover the current behavior, or
set it to your preference with <<fpsetroundtoi>>.  The <[flag]>
argument to <<fpsetroundtoi>>, and the results of both functions, are
encoded as follows:
o+
o FP_DDI_TOZ
Always truncate numbers (round toward zero) when coercing to integers,
regardless of the general rounding rules in effect.
o FP_RDI_RD
Follow the general rounding rules when coercing to integer.
o-

NEWPAGE
RETURNS
<<fpgetround>> and <<fpgetroundtoi>> return the current rounding
direction and integer-coercion rounding flag, respectively.
<<fpsetround>> and <<fpsetroundtoi>> return the last rounding
direction and integer-coercion rounding flag.

PORTABILITY
These functions are not ANSI C.
*/
