/*
FUNCTION
        <<acos>>, <<acosf>>---Arccosine

INDEX
	acos
INDEX
	acosf

ANSI_SYNOPSIS
        #include <math.h>
        double acos(double <[x]>);
        float acosf(float <[x]>);

TRAD_SYNOPSIS
        #include <math.h>
        double acos(<[x]>)
        double <[x]>;

        float acosf(<[x]>)
        float <[x]>;



DESCRIPTION

	<<acos>> computes the inverse cosine (Arccosine) of the input value.
	Arguments to <<acos>> must be in the range @minus{}1 to 1. 

	<<acosf>> is identical to <<acos>>, except that it performs
	its calculations on <<floats>>.

RETURNS
	@ifinfo
	<<acos>> and <<acosf>> return values in radians, in the range of 0 to pi.
	@end ifinfo
	@tex
	<<acos>> and <<acosf>> return values in radians, in the range of <<0>> to $\pi$.
	@end tex

	If <[x]> is not between @minus{}1 and 1, the returned value is NaN
	(not a number) the global variable <<errno>> is set to <<EDOM>>, and a
	<<DOMAIN ERROR>> message is sent as standard error output.

	You can modify error handling for these functions using <<matherr>>.


QUICKREF ANSI SVID POSIX RENTRANT
 acos	 y,y,y,m
 acosf   n,n,n,m

MATHREF  
 acos, [-1,1], acos(arg),,,
 acos, NAN,    arg,DOMAIN,EDOM

MATHREF
 acosf, [-1,1], acosf(arg),,,
 acosf, NAN,    argf,DOMAIN,EDOM
 
*/



#include "mathimpl.h"

#define DOUBLE
#define ACOSNAME "acos"
#include "acos.h"
#undef ACOSNAME

#define ACOSNAME "acosf"
#define FLOAT
#include "acos.h"
