#include "funcs.h"
TYPE_RET      
_DEFUN(asinh,(x),TYPE_ARG x)     
{     
  TYPE s;     
  int neg;     

  if(!finite(x))     
  {     
    return __matherror(SNAME, x, 0.0, DOMAIN, x);  
  }     
  if (x < 0) {    
      neg = 1;   
      x = -x;    
    }    
  else    
  {    
    neg = 0;    
  }    

  if(x>1e-20)        
  {     
    if(x < 1e20)      
    {        
      s = 1 / x;      
      s = log1p( x + x/(s+ sqrt(1.0+s*s)));   
      return neg ? -s : s;   
    }       
    else			/* if |x| > big */  
    {       
      s= log1p(x) + M_LN2LO;    
      s += M_LN2HI;    
      return neg ? -s : s   ;
    }     
  }     
  else				/* if |x| < small */  
   return(x);     
}     
     
     
